/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.elasticsearch.ColumnMetaData;
import cloud.agileframework.elasticsearch.types.ElasticsearchType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cursor {
    private Schema schema;
    private List<Row> rows;
    private int currentRow = -1;
    private Map<String, Integer> labelToIndexMap;

    public Cursor(Schema schema, List<Row> rows) {
        this.schema = schema;
        this.rows = rows;
        this.initLabelToIndexMap();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Object getColumn(int index) {
        if (index < 0 || index >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column Index out of range: " + index);
        }
        return this.rows.get(this.currentRow).get(index);
    }

    public int getColumnCount() {
        return this.schema.getNumberOfColumns();
    }

    public boolean next() {
        if (this.currentRow < this.rows.size() - 1) {
            ++this.currentRow;
            return true;
        }
        return false;
    }

    public Integer findColumn(String label) {
        return this.labelToIndexMap.get(label);
    }

    private void initLabelToIndexMap() {
        this.labelToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.schema.getNumberOfColumns(); ++i) {
            ColumnMetaData columnMetaData = this.schema.getColumnMetaData(i);
            this.labelToIndexMap.put(columnMetaData.getLabel(), i);
        }
    }

    public static class Schema {
        private final List<ColumnMetaData> columnMetaDataList;
        private final int numberOfColumns;

        public Schema(List<ColumnMetaData> columnMetaDataList) {
            this.columnMetaDataList = columnMetaDataList;
            this.numberOfColumns = columnMetaDataList != null ? columnMetaDataList.size() : 0;
        }

        public int getNumberOfColumns() {
            return this.numberOfColumns;
        }

        public ColumnMetaData getColumnMetaData(int index) {
            return this.columnMetaDataList.get(index);
        }

        public ElasticsearchType getElasticsearchType(int index) {
            return this.columnMetaDataList.get(index).getEsType();
        }
    }

    public static class Row {
        private List<Object> columnData;

        public Row(List<Object> columnData) {
            this.columnData = columnData;
        }

        public Object get(int index) {
            return this.columnData.get(index);
        }
    }
}

