/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch;

import cloud.agileframework.common.util.http.HttpUtil;
import cloud.agileframework.elasticsearch.ConnectionEnhanceImpl;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.RestClients;

public class Driver
implements java.sql.Driver {
    private static Logger log = LoggerFactory.getLogger(Driver.class);
    public static final String URL_PREFIX = "jdbc:elastic://";

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        List urls = Arrays.stream(url.split(",")).map(s -> s.startsWith("http") ? s : "http://" + s).map(URI::create).collect(Collectors.toList());
        InetSocketAddress[] inetSocketAddresses = (InetSocketAddress[])urls.stream().map(a -> InetSocketAddress.createUnresolved(a.getHost(), a.getPort())).toArray(InetSocketAddress[]::new);
        ClientConfiguration.MaybeSecureClientConfigurationBuilder builder = ClientConfiguration.builder().connectedTo(inetSocketAddresses);
        if ("https".equals(((URI)urls.get(0)).getScheme())) {
            try {
                builder.usingSsl(HttpUtil.createIgnoreVerifySSL((String)"SSL"), (HostnameVerifier)NoopHostnameVerifier.INSTANCE).withBasicAuth(info.getProperty("user"), info.getProperty("password")).build();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return new ConnectionEnhanceImpl(RestClients.create((ClientConfiguration)builder.build()).lowLevelRest(), url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException E) {
            throw new RuntimeException("Can't register driver!");
        }
    }
}

