/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.proxy;

import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.elasticsearch.BaseStatement;
import cloud.agileframework.elasticsearch.proxy.JdbcResponse;
import cloud.agileframework.elasticsearch.proxy.SqlParseProvider;
import cloud.agileframework.elasticsearch.proxy.batch.BatchHandler;
import cloud.agileframework.elasticsearch.proxy.create.CreateHandler;
import cloud.agileframework.elasticsearch.proxy.delete.DeleteHandler;
import cloud.agileframework.elasticsearch.proxy.insert.InsertHandler;
import cloud.agileframework.elasticsearch.proxy.select.OpendistroSelectHandler;
import cloud.agileframework.elasticsearch.proxy.select.SelectHandler;
import cloud.agileframework.elasticsearch.proxy.update.UpdateHandler;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Vector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRequest {
    private static Logger logger = LoggerFactory.getLogger(JdbcRequest.class);
    private static final SqlParseProvider[] handlers = new SqlParseProvider[]{new SelectHandler(), new OpendistroSelectHandler(), new CreateHandler(), new InsertHandler(), new UpdateHandler(), new DeleteHandler(), new BatchHandler()};
    private String url;
    private RequestMethod method;
    private String body;
    private SqlParseProvider handler;
    private String index;
    private BaseStatement statement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcResponse send(String sql, BaseStatement baseStatement) throws SQLException, IOException {
        Vector<SendInfo> sendInfo = new Vector<SendInfo>();
        SQLStatement sqlStatement = JdbcRequest.to(sql);
        boolean support = false;
        for (SqlParseProvider handler : handlers) {
            if (!handler.accept(sqlStatement)) continue;
            support = true;
            JdbcRequest request = handler.of(sqlStatement);
            if (request == null) continue;
            SendInfo.SendInfoBuilder builder = SendInfo.builder().request(request);
            request.setStatement(baseStatement);
            try {
                JdbcResponse response = request.send();
                if (response == null) continue;
                builder.response(response);
                break;
            }
            catch (Exception e) {
                builder.e(e);
            }
            finally {
                sendInfo.add(builder.build());
            }
        }
        if (!support || sendInfo.isEmpty()) {
            throw new SQLFeatureNotSupportedException(sql);
        }
        SendInfo last = (SendInfo)sendInfo.lastElement();
        if (last.getE() != null) {
            Exception exception = new Exception();
            for (SendInfo o : sendInfo) {
                JdbcRequest nextRequest = o.getRequest();
                logger.error("Send data:\n{} {}\n{}", new Object[]{nextRequest.getMethod(), nextRequest.getUrl(), nextRequest.getBody()});
                logger.error("Send data fail", (Throwable)o.getE());
                exception.addSuppressed(o.getE());
            }
            throw new SQLException(exception);
        }
        JdbcRequest lastRequest = last.getRequest();
        logger.debug("Send data:\n{} {}\n{}", new Object[]{lastRequest.getMethod(), lastRequest.getUrl(), lastRequest.getBody()});
        return last.getResponse();
    }

    public static JdbcRequest of(String sql, BaseStatement baseStatement) throws SQLException {
        SQLStatement sqlStatement = JdbcRequest.to(sql);
        for (SqlParseProvider handler : handlers) {
            JdbcRequest request;
            if (!handler.accept(sqlStatement) || (request = handler.of(sqlStatement)) == null) continue;
            request.setStatement(baseStatement);
            return request;
        }
        throw new SQLFeatureNotSupportedException(sql);
    }

    public static JdbcRequest of(List<SQLStatement> sqls, BaseStatement baseStatement) throws SQLException {
        for (SqlParseProvider handler : handlers) {
            try {
                JdbcRequest request = handler.of(sqls);
                if (request == null) continue;
                request.setStatement(baseStatement);
                return request;
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    public static SQLStatement to(String sql) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)DbType.elastic_search);
        SQLStatement statement = parser.parseStatement();
        SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor((DbType)DbType.elastic_search);
        statement.accept((SQLASTVisitor)visitor);
        return statement;
    }

    public String getUrl() {
        if (!this.url.startsWith("/")) {
            this.url = "/" + this.url;
        }
        return this.url;
    }

    public JdbcResponse send() throws IOException, SQLException {
        Request request = new Request(this.getMethod().name(), this.getUrl());
        request.setJsonEntity(this.getBody());
        Response result = this.statement.getConnection().getRestClient().performRequest(request);
        return this.getHandler().toResponse(this.statement, result.getEntity().getContent());
    }

    JdbcRequest(String url, RequestMethod method, String body, SqlParseProvider handler, String index, BaseStatement statement) {
        this.url = url;
        this.method = method;
        this.body = body;
        this.handler = handler;
        this.index = index;
        this.statement = statement;
    }

    public static JdbcRequestBuilder builder() {
        return new JdbcRequestBuilder();
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public SqlParseProvider getHandler() {
        return this.handler;
    }

    public String getIndex() {
        return this.index;
    }

    public BaseStatement getStatement() {
        return this.statement;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(RequestMethod method) {
        this.method = method;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setHandler(SqlParseProvider handler) {
        this.handler = handler;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setStatement(BaseStatement statement) {
        this.statement = statement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcRequest)) {
            return false;
        }
        JdbcRequest other = (JdbcRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        RequestMethod this$method = this.getMethod();
        RequestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        SqlParseProvider this$handler = this.getHandler();
        SqlParseProvider other$handler = other.getHandler();
        if (this$handler == null ? other$handler != null : !this$handler.equals(other$handler)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        BaseStatement this$statement = this.getStatement();
        BaseStatement other$statement = other.getStatement();
        return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JdbcRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        RequestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        SqlParseProvider $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        BaseStatement $statement = this.getStatement();
        result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
        return result;
    }

    public String toString() {
        return "JdbcRequest(url=" + this.getUrl() + ", method=" + this.getMethod() + ", body=" + this.getBody() + ", handler=" + this.getHandler() + ", index=" + this.getIndex() + ", statement=" + this.getStatement() + ")";
    }

    public static class JdbcRequestBuilder {
        private String url;
        private RequestMethod method;
        private String body;
        private SqlParseProvider handler;
        private String index;
        private BaseStatement statement;

        JdbcRequestBuilder() {
        }

        public JdbcRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public JdbcRequestBuilder method(RequestMethod method) {
            this.method = method;
            return this;
        }

        public JdbcRequestBuilder body(String body) {
            this.body = body;
            return this;
        }

        public JdbcRequestBuilder handler(SqlParseProvider handler) {
            this.handler = handler;
            return this;
        }

        public JdbcRequestBuilder index(String index) {
            this.index = index;
            return this;
        }

        public JdbcRequestBuilder statement(BaseStatement statement) {
            this.statement = statement;
            return this;
        }

        public JdbcRequest build() {
            return new JdbcRequest(this.url, this.method, this.body, this.handler, this.index, this.statement);
        }

        public String toString() {
            return "JdbcRequest.JdbcRequestBuilder(url=" + this.url + ", method=" + this.method + ", body=" + this.body + ", handler=" + this.handler + ", index=" + this.index + ", statement=" + this.statement + ")";
        }
    }

    private static class SendInfo {
        private JdbcRequest request;
        private JdbcResponse response;
        private Exception e;

        SendInfo(JdbcRequest request, JdbcResponse response, Exception e) {
            this.request = request;
            this.response = response;
            this.e = e;
        }

        public static SendInfoBuilder builder() {
            return new SendInfoBuilder();
        }

        public JdbcRequest getRequest() {
            return this.request;
        }

        public JdbcResponse getResponse() {
            return this.response;
        }

        public Exception getE() {
            return this.e;
        }

        public void setRequest(JdbcRequest request) {
            this.request = request;
        }

        public void setResponse(JdbcResponse response) {
            this.response = response;
        }

        public void setE(Exception e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendInfo)) {
                return false;
            }
            SendInfo other = (SendInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JdbcRequest this$request = this.getRequest();
            JdbcRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            JdbcResponse this$response = this.getResponse();
            JdbcResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
                return false;
            }
            Exception this$e = this.getE();
            Exception other$e = other.getE();
            return !(this$e == null ? other$e != null : !this$e.equals(other$e));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JdbcRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            JdbcResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            Exception $e = this.getE();
            result = result * 59 + ($e == null ? 43 : $e.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcRequest.SendInfo(request=" + this.getRequest() + ", response=" + this.getResponse() + ", e=" + this.getE() + ")";
        }

        public static class SendInfoBuilder {
            private JdbcRequest request;
            private JdbcResponse response;
            private Exception e;

            SendInfoBuilder() {
            }

            public SendInfoBuilder request(JdbcRequest request) {
                this.request = request;
                return this;
            }

            public SendInfoBuilder response(JdbcResponse response) {
                this.response = response;
                return this;
            }

            public SendInfoBuilder e(Exception e) {
                this.e = e;
                return this;
            }

            public SendInfo build() {
                return new SendInfo(this.request, this.response, this.e);
            }

            public String toString() {
                return "JdbcRequest.SendInfo.SendInfoBuilder(request=" + this.request + ", response=" + this.response + ", e=" + this.e + ")";
            }
        }
    }
}

