/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.proxy.batch;

import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.SqlParseProvider;
import cloud.agileframework.elasticsearch.proxy.batch.BatchResponse;
import cloud.agileframework.elasticsearch.proxy.common.BatchUtil;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastjson2.JSON;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.stream.Collectors;

public class BatchHandler
implements SqlParseProvider<BatchResponse, SQLInsertStatement> {
    @Override
    public JdbcRequest of(List<SQLInsertStatement> statement) throws SQLFeatureNotSupportedException {
        String body = statement.stream().flatMap(sql -> BatchUtil.to(sql).stream()).map(JSON::toJSONString).collect(Collectors.joining("\n"));
        return JdbcRequest.builder().url("_bulk").method(RequestMethod.POST).body(body + "\n").handler(this).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchHandler)) {
            return false;
        }
        BatchHandler other = (BatchHandler)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchHandler;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BatchHandler()";
    }
}

