/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.proxy.common;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastjson2.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class BatchUtil {
    public static List<JSONObject> to(SQLInsertStatement sqlExpr) {
        ArrayList list = Lists.newArrayList();
        sqlExpr.getValuesList().forEach(valuesClause -> {
            JSONObject body = new JSONObject();
            JSONObject index = new JSONObject();
            body.put((Object)"create", (Object)index);
            index.put((Object)"_index", (Object)sqlExpr.getTableName().getSimpleName().toLowerCase(Locale.ROOT));
            index.put((Object)"_type", (Object)"_doc");
            List columns = sqlExpr.getColumns();
            List fields = columns.stream().map(SQLUtils::toSQLString).collect(Collectors.toList());
            int i = fields.indexOf("_id");
            if (i > -1) {
                index.put((Object)"_id", (Object)SQLUtils.toSQLString((SQLObject)((SQLObject)valuesClause.getValues().get(i))));
            }
            list.add(body);
            list.add(BatchUtil.to(columns, valuesClause));
        });
        return list;
    }

    private static JSONObject to(List<SQLExpr> columns, SQLInsertStatement.ValuesClause valuesClause) {
        JSONObject body = new JSONObject();
        List values = valuesClause.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String column = columns.get(i).toString();
            if ("_id".equals(column)) continue;
            SQLExpr v = (SQLExpr)values.get(i);
            Object value = v instanceof SQLValuableExpr ? ((SQLValuableExpr)v).getValue() : SQLUtils.toSQLString((SQLObject)v);
            body.put((Object)column, value);
        }
        return body;
    }
}

