/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.proxy.create;

import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.elasticsearch.proxy.JdbcRequest;
import cloud.agileframework.elasticsearch.proxy.SqlParseProvider;
import cloud.agileframework.elasticsearch.proxy.create.CreateResponse;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateHandler
implements SqlParseProvider<CreateResponse, SQLCreateTableStatement> {
    @Override
    public JdbcRequest of(SQLCreateTableStatement statement) {
        String index = statement.getTableName().toLowerCase(Locale.ROOT);
        Map<String, JSONObject> properties = statement.getColumnDefinitions().stream().collect(Collectors.toMap(SQLColumnDefinition::getColumnName, c -> {
            String type = c.getDataType().getName();
            SQLExpr comment = c.getComment();
            JSONObject property = new JSONObject();
            property.put((Object)"type", (Object)type);
            if (comment != null) {
                try {
                    JSONObject attr = JSON.parseObject((String)((SQLCharExpr)comment).getValue().toString());
                    property.putAll((Map)attr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return property;
        }));
        JSONObject createTableJson = new JSONObject();
        JSONObject mappings = new JSONObject();
        mappings.put((Object)"properties", properties);
        createTableJson.put((Object)"mappings", (Object)mappings);
        SQLExpr comment = statement.getComment();
        if (comment != null) {
            try {
                JSONObject createTableConfigJson = JSON.parseObject((String)((SQLCharExpr)comment).getValue().toString());
                createTableJson.putAll((Map)createTableConfigJson);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return JdbcRequest.builder().handler(this).url(index).method(RequestMethod.PUT).index(index).body(createTableJson.toJSONString(new JSONWriter.Feature[0])).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateHandler)) {
            return false;
        }
        CreateHandler other = (CreateHandler)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateHandler;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "CreateHandler()";
    }
}

