/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.types;

import cloud.agileframework.elasticsearch.types.NumberType;
import java.sql.SQLException;
import java.util.Map;

public class ByteType
extends NumberType<Byte> {
    public static final ByteType INSTANCE = new ByteType();

    private ByteType() {
    }

    @Override
    public Byte fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return (byte)0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return this.asByte((String)value);
        }
        if (value instanceof Number) {
            return this.asByte((Number)value);
        }
        throw this.objectConversionException(value);
    }

    private Byte asByte(String value) throws SQLException {
        try {
            return this.asByte(Double.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            throw this.stringConversionException(value, nfe);
        }
    }

    private Byte asByte(Number value) throws SQLException {
        return (byte)this.getDoubleValueWithinBounds(value, -128.0, 127.0);
    }

    @Override
    public String getTypeName() {
        return "Byte";
    }
}

