/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.types;

import cloud.agileframework.elasticsearch.types.NumberType;
import java.sql.SQLException;
import java.util.Map;

public class FloatType
extends NumberType<Float> {
    public static final FloatType INSTANCE = new FloatType();

    private FloatType() {
    }

    @Override
    public Float fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return Float.valueOf(0.0f);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            return this.asFloat((String)value);
        }
        if (value instanceof Number) {
            return this.asFloat((Number)value);
        }
        throw this.objectConversionException(value);
    }

    private Float asFloat(String value) throws SQLException {
        try {
            return this.asFloat(Double.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            throw this.stringConversionException(value, nfe);
        }
    }

    private Float asFloat(Number value) throws SQLException {
        return Float.valueOf((float)this.getDoubleValueWithinBounds(value, -3.4028234663852886E38, 3.4028234663852886E38));
    }

    @Override
    public String getTypeName() {
        return "Float";
    }

    @Override
    public boolean roundOffValue() {
        return false;
    }
}

