/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.elasticsearch.types;

import cloud.agileframework.elasticsearch.types.TypeHelper;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

public class TimestampType
implements TypeHelper<Timestamp> {
    public static final TimestampType INSTANCE = new TimestampType();

    private TimestampType() {
    }

    @Override
    public Timestamp fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        Calendar calendar;
        if (value == null) {
            return null;
        }
        Calendar calendar2 = calendar = conversionParams != null ? (Calendar)conversionParams.get("calendar") : null;
        if (value instanceof Timestamp) {
            return this.asTimestamp((Timestamp)value, calendar);
        }
        if (value instanceof String) {
            return this.asTimestamp((String)value, calendar);
        }
        if (value instanceof Number) {
            return this.asTimestamp((Number)value);
        }
        throw this.objectConversionException(value);
    }

    public Timestamp asTimestamp(Timestamp value, Calendar calendar) throws SQLException {
        if (calendar == null) {
            return value;
        }
        return this.localDateTimeToTimestamp(value.toLocalDateTime(), calendar);
    }

    private Timestamp localDateTimeToTimestamp(LocalDateTime ldt, Calendar calendar) {
        calendar.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        calendar.set(14, ldt.getNano() / 1000000);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public Timestamp asTimestamp(String value, Calendar calendar) throws SQLException {
        try {
            if (value.length() > 11 && value.charAt(10) == 'T') {
                value = value.replace('T', ' ');
            }
            if (value.length() > 23) {
                if (value.length() == 24 && value.charAt(23) == 'Z') {
                    value = value.substring(0, 23);
                } else if (value.charAt(23) == '+' || value.charAt(23) == '-') {
                    if (calendar == null) {
                        calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT" + value.substring(23)));
                    }
                    value = value.substring(0, 23);
                }
            }
            if (calendar == null) {
                return Timestamp.valueOf(value);
            }
            Timestamp ts = Timestamp.valueOf(value);
            return this.localDateTimeToTimestamp(ts.toLocalDateTime(), calendar);
        }
        catch (IllegalArgumentException iae) {
            throw this.stringConversionException(value, iae);
        }
    }

    public Timestamp asTimestamp(Number value) throws SQLException {
        return new Timestamp(value.longValue());
    }

    @Override
    public String getTypeName() {
        return "Timestamp";
    }
}

