/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.annotation;

import cloud.agileframework.common.util.collection.CollectionsUtil;
import cloud.agileframework.mvc.annotation.Init;
import cloud.agileframework.mvc.annotation.ParsingMethodAfter;
import cloud.agileframework.spring.util.BeanUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

public class ParsingInit
implements ParsingMethodAfter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<InitApiInfo> inits = new ArrayList<InitApiInfo>();

    @Override
    public void parsing(String beanName, Method method) {
        Init init = (Init)method.getAnnotation(this.getAnnotation());
        if (!ObjectUtils.isEmpty((Object)init)) {
            this.inits.add(InitApiInfo.builder().order(init.order()).beanName(beanName).method(method).build());
        }
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return Init.class;
    }

    @Transactional(rollbackFor={Exception.class})
    public void parse(Object bean, Method method) {
        method.setAccessible(true);
        Init init = (Init)method.getAnnotation(this.getAnnotation());
        if (!ObjectUtils.isEmpty((Object)init)) {
            try {
                this.logger.info("\u542f\u52a8\u521d\u59cb\u5316\u65b9\u6cd5:{}", (Object)method.toGenericString());
                method.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
            }
        }
    }

    public void parse() {
        CollectionsUtil.sort(this.inits, (String)"order");
        for (InitApiInfo initApiInfo : this.inits) {
            try {
                this.parse(BeanUtil.getBean((String)initApiInfo.beanName), initApiInfo.method);
            }
            catch (Exception exception) {}
        }
    }

    private static class InitApiInfo {
        private int order;
        private String beanName;
        private Method method;

        InitApiInfo(int order, String beanName, Method method) {
            this.order = order;
            this.beanName = beanName;
            this.method = method;
        }

        public static InitApiInfoBuilder builder() {
            return new InitApiInfoBuilder();
        }

        public int getOrder() {
            return this.order;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitApiInfo)) {
                return false;
            }
            InitApiInfo other = (InitApiInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrder() != other.getOrder()) {
                return false;
            }
            String this$beanName = this.getBeanName();
            String other$beanName = other.getBeanName();
            if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitApiInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getOrder();
            String $beanName = this.getBeanName();
            result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }

        public String toString() {
            return "ParsingInit.InitApiInfo(order=" + this.getOrder() + ", beanName=" + this.getBeanName() + ", method=" + this.getMethod() + ")";
        }

        public static class InitApiInfoBuilder {
            private int order;
            private String beanName;
            private Method method;

            InitApiInfoBuilder() {
            }

            public InitApiInfoBuilder order(int order) {
                this.order = order;
                return this;
            }

            public InitApiInfoBuilder beanName(String beanName) {
                this.beanName = beanName;
                return this;
            }

            public InitApiInfoBuilder method(Method method) {
                this.method = method;
                return this;
            }

            public InitApiInfo build() {
                return new InitApiInfo(this.order, this.beanName, this.method);
            }

            public String toString() {
                return "ParsingInit.InitApiInfo.InitApiInfoBuilder(order=" + this.order + ", beanName=" + this.beanName + ", method=" + this.method + ")";
            }
        }
    }
}

