/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.base;

import cloud.agileframework.spring.util.MessageUtil;
import cloud.agileframework.spring.util.ServletUtil;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public final class RETURN {
    public static final RETURN SUCCESS = RETURN.byMessageWithDefault("000000:\u670d\u52a1\u6267\u884c\u6210\u529f", "agile.success.success");
    public static final RETURN LOGOUT_SUCCESS = RETURN.byMessageWithDefault("000001:\u9000\u51fa\u6210\u529f", "agile.success.logout");
    public static final RETURN FAIL = RETURN.byMessageWithDefault("100000:\u64cd\u4f5c\u5931\u8d25", "agile.error.fail");
    public static final RETURN NOT_FOUND = RETURN.byMessage("100001:\u8bf7\u6c42\u670d\u52a1\u4e0d\u5b58\u5728", HttpStatus.NOT_FOUND, "agile.error.not-found", new Object[0]);
    public static final RETURN PARAMETER_ERROR = RETURN.byMessageWithDefault("100002:\u53c2\u6570\u9519\u8bef", "agile.error.paramError");
    public static final RETURN EXPRESSION = RETURN.byMessageWithDefault("200001:\u7a0b\u5e8f\u5f02\u5e38", "agile.exception.expression");
    private final String code;
    private final String msg;
    private final HttpStatus status;

    private RETURN(String code, String msg, HttpStatus status) {
        this.code = code.trim();
        this.msg = msg.trim();
        this.status = status == null ? HttpStatus.OK : status;
        HttpServletResponse response = ServletUtil.getCurrentResponse();
        if (response != null) {
            response.setStatus(this.status.value());
        }
    }

    public static RETURN of(String code, String msg) {
        return new RETURN(code, msg, null);
    }

    public static RETURN of(String code, String msg, HttpStatus status) {
        return new RETURN(code, msg, status);
    }

    public static RETURN byMessage(String defaultValue, HttpStatus status, String key, Object ... params) {
        String message = MessageUtil.message((String)key, (Object[])params);
        if (defaultValue == null && message == null) {
            throw new RuntimeException(String.format("defaultValue and message cannot both be null,message %s not found", key));
        }
        if (message != null) {
            try {
                return RETURN.byMessage(status, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return RETURN.byMessage(status, defaultValue);
    }

    public static RETURN byMessage(HttpStatus status, String message) {
        String code;
        if (message != null && message.contains(":")) {
            int splitIndex = message.indexOf(":");
            code = message.substring(0, splitIndex);
            message = message.substring(splitIndex + 1);
        } else if (status != null) {
            code = status.value() + "";
            message = status.getReasonPhrase();
        } else {
            throw new RuntimeException("status and message cannot both be null");
        }
        return RETURN.of(code, message, status);
    }

    public static RETURN byMessageWithDefault(String defaultValue, String key) {
        return RETURN.byMessage(defaultValue, null, key, new Object[0]);
    }

    public static RETURN byMessage(String key, Object ... params) {
        return RETURN.byMessage(null, null, key, params);
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public HttpStatus getStatus() {
        return this.status;
    }
}

