/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.config;

import cloud.agileframework.mvc.container.AgileHandlerMapping;
import cloud.agileframework.mvc.container.AgileHandlerMethodArgumentResolver;
import cloud.agileframework.mvc.container.CustomAsyncHandlerInterceptor;
import cloud.agileframework.mvc.container.CustomHandlerInterceptor;
import cloud.agileframework.mvc.container.CustomHandlerMethodReturnValueHandler;
import cloud.agileframework.mvc.container.RETURNHandlerMethodReturnValueHandler;
import cloud.agileframework.mvc.filter.CorsFilter;
import cloud.agileframework.mvc.filter.RequestWrapperFilter;
import cloud.agileframework.mvc.properties.CorsFilterProperties;
import cloud.agileframework.mvc.provider.ArgumentInitHandlerProvider;
import cloud.agileframework.mvc.provider.ArgumentValidationHandlerProvider;
import cloud.agileframework.mvc.view.JsonViewResolver;
import cloud.agileframework.mvc.view.JumpViewResolver;
import cloud.agileframework.mvc.view.PlainViewResolver;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SpringMvcAutoConfiguration
implements WebMvcConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CorsFilterProperties corsFilterProperties;

    @Autowired
    public SpringMvcAutoConfiguration(CorsFilterProperties corsFilterProperties) {
        this.corsFilterProperties = corsFilterProperties;
    }

    @Bean
    @ConditionalOnClass(value={CorsFilter.class})
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        FilterRegistrationBean corsFilter = new FilterRegistrationBean();
        corsFilter.setFilter((Filter)new CorsFilter());
        corsFilter.addUrlPatterns(new String[]{"/*"});
        corsFilter.addInitParameter("allowOrigin", this.corsFilterProperties.getAllowOrigin());
        corsFilter.addInitParameter("allowMethods", this.corsFilterProperties.getAllowMethods());
        corsFilter.addInitParameter("allowCredentials", Boolean.toString(this.corsFilterProperties.isAllowCredentials()));
        corsFilter.addInitParameter("allowHeaders", this.corsFilterProperties.getAllowHeaders());
        this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316\u8de8\u57df\u8fc7\u6ee4\u5668");
        return corsFilter;
    }

    @Bean
    @ConditionalOnClass(value={RequestWrapperFilter.class})
    public FilterRegistrationBean<RequestWrapperFilter> requestWrapperFilter() {
        FilterRegistrationBean requestFilter = new FilterRegistrationBean();
        requestFilter.setFilter((Filter)new RequestWrapperFilter());
        requestFilter.addUrlPatterns(new String[]{"/*"});
        this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316Request\u5305\u88c5\u8fc7\u6ee4\u5668");
        return requestFilter;
    }

    @Bean
    @Order(value=-2147483648)
    public AgileHandlerMapping agileHandlerMapping() {
        return new AgileHandlerMapping();
    }

    @Bean
    ArgumentInitHandlerProvider argumentInitHandlerProvider() {
        return new ArgumentInitHandlerProvider();
    }

    @Bean
    ArgumentValidationHandlerProvider argumentValidationHandlerProvider() {
        return new ArgumentValidationHandlerProvider();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(this.agileHandlerMethodArgumentResolver());
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        registry.viewResolver((ViewResolver)new JsonViewResolver());
        registry.viewResolver((ViewResolver)new PlainViewResolver());
        registry.viewResolver((ViewResolver)new JumpViewResolver());
        registry.enableContentNegotiation(new View[0]);
    }

    @Bean
    AgileHandlerMethodArgumentResolver agileHandlerMethodArgumentResolver() {
        return new AgileHandlerMethodArgumentResolver();
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> handlers) {
        handlers.add(new CustomHandlerMethodReturnValueHandler());
        handlers.add(new RETURNHandlerMethodReturnValueHandler());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new CustomHandlerInterceptor());
        registry.addInterceptor((HandlerInterceptor)this.customAsyncHandlerInterceptor());
    }

    @Bean
    CustomAsyncHandlerInterceptor customAsyncHandlerInterceptor() {
        return new CustomAsyncHandlerInterceptor();
    }
}

