/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.container;

import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.spring.util.AopUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class AgileHandlerMapping
extends RequestMappingHandlerMapping {
    private final Map<String, RequestMappingInfo> cache = new HashMap<String, RequestMappingInfo>();

    private RequestMappingInfo createMappingInfo(Mapping mapping, RequestCondition<?> condition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])this.resolveEmbeddedValuesInPatterns(mapping.path())).methods(mapping.method()).params(mapping.params()).headers(mapping.headers()).consumes(mapping.consumes()).produces(mapping.produces()).mappingName(mapping.name());
        if (condition != null) {
            builder.customCondition(condition);
        }
        return builder.build();
    }

    @Nullable
    private RequestMappingInfo createMappingInfo(AnnotatedElement element) {
        Mapping requestMapping = (Mapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, Mapping.class);
        RequestCondition condition = element instanceof Class ? this.getCustomTypeCondition((Class)element) : this.getCustomMethodCondition((Method)element);
        return requestMapping != null ? this.createMappingInfo(requestMapping, condition) : null;
    }

    public RequestMappingInfo getMappingForMethod(final Method method, final Class<?> handlerType) {
        RequestMappingInfo info = this.createMappingInfo(method);
        if (info != null) {
            RequestMappingInfo typeInfo = this.createMappingInfo(handlerType);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
        } else {
            AgileService agileService = handlerType.getAnnotation(AgileService.class);
            if (agileService == null) {
                return null;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return null;
            }
            info = this.createMappingInfo(new Mapping(){
                final String path;
                {
                    this.path = "/" + handlerType.getSimpleName() + "/" + method.getName();
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Mapping.class;
                }

                @Override
                public String name() {
                    return "";
                }

                @Override
                public String[] value() {
                    return new String[]{this.path};
                }

                @Override
                public String[] path() {
                    return new String[]{this.path};
                }

                @Override
                public RequestMethod[] method() {
                    return new RequestMethod[]{RequestMethod.POST, RequestMethod.GET};
                }

                @Override
                public String[] params() {
                    return new String[0];
                }

                @Override
                public String[] headers() {
                    return new String[0];
                }

                @Override
                public String[] consumes() {
                    return new String[0];
                }

                @Override
                public String[] produces() {
                    return new String[0];
                }
            }, null);
        }
        return info;
    }

    public void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        for (String path : mapping.getPatternsCondition().getPatterns()) {
            RequestMappingInfo cacheMapping = this.cache.get(path);
            if (!ObjectUtils.isEmpty((Object)cacheMapping)) {
                Set methods = mapping.getMethodsCondition().getMethods();
                for (RequestMethod requestMethod : cacheMapping.getMethodsCondition().getMethods()) {
                    if (!methods.contains(requestMethod)) continue;
                    String message = method.getAnnotation(Mapping.class) == null ? String.format("Mapping\u6620\u5c04\u91cd\u590d\uff0cAgileService\u5c42\u5728\u751f\u6210\u9ed8\u8ba4\u6620\u5c04\u5730\u5740\u65f6\uff0c\u9700\u8981\u786e\u4fdd\u4ec5\u6709\u4e00\u4e2apublic\u91cd\u8f7d\u65b9\u6cd5\uff0c\u5426\u5219\u53ef\u4ee5\u58f0\u660eMapping\u6216\u4fee\u6539\u53ef\u89c1\u6027\u907f\u514d\u95ee\u9898\u53d1\u751f\uff0c\u91cd\u590d\u7c7b:%s,\u91cd\u590d\u65b9\u6cd5:%s", AopProxyUtils.ultimateTargetClass((Object)handler).getName(), method.getName()) : String.format("Mapping\u6620\u5c04\u91cd\u590d\uff0c\u91cd\u590d\u7c7b:%s,\u91cd\u590d\u65b9\u6cd5:%s", AopProxyUtils.ultimateTargetClass((Object)handler).getName(), method.getName());
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)message);
                    }
                    throw new IllegalStateException(message);
                }
            }
            this.cache.put(path, mapping);
        }
        super.registerHandlerMethod(handler, method, mapping);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("[class:%s][method:%s][url:%s]", AopUtil.isAopProxy(handler.getClass()) ? AopProxyUtils.ultimateTargetClass(handler.getClass()).getCanonicalName() : handler.getClass().getCanonicalName(), method.getName(), String.join((CharSequence)",", mapping.getPatternsCondition().getPatterns())));
        }
    }
}

