/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.container;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.mvc.annotation.AgileInParam;
import cloud.agileframework.mvc.param.AgileParam;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;

public class AgileHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        String parameterName = parameter.getParameterName();
        if (parameterName == null) {
            return false;
        }
        return AgileParam.containsKey(parameterName) || parameter.getParameterAnnotation(AgileInParam.class) != null;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (mavContainer != null) {
            ModelMap defaultModel = mavContainer.getDefaultModel();
            defaultModel.clear();
        }
        Object result = null;
        Type type = parameter.getGenericParameterType();
        AgileInParam agileInParam = (AgileInParam)parameter.getParameterAnnotation(AgileInParam.class);
        if (agileInParam != null) {
            result = this.parsing(type, agileInParam.value());
        }
        if (result == null) {
            String parameterName = parameter.getParameterName();
            if (parameterName == null) {
                return null;
            }
            result = this.parsing(type, parameterName);
        }
        return result;
    }

    private Object parsing(Type type, String parameterName) throws IOException {
        if (type instanceof Class && MultipartFile.class.isAssignableFrom((Class)type)) {
            return AgileParam.getInParamOfFile(parameterName);
        }
        if (type instanceof Class && InputStream.class.isAssignableFrom((Class)type)) {
            return AgileParam.getInParamOfFile(parameterName).getInputStream();
        }
        if (type instanceof Class && parameterName.equalsIgnoreCase("body")) {
            return AgileParam.getInParam((Class)type);
        }
        return AgileParam.getInParam(parameterName, new TypeReference(type));
    }
}

