/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.exception;

import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.mvc.base.AbstractResponseFormat;
import cloud.agileframework.mvc.base.Head;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.AbstractCustomException;
import cloud.agileframework.mvc.exception.AgileArgumentException;
import cloud.agileframework.mvc.exception.NoSuchRequestMethodException;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.util.ViewUtil;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.MessageUtil;
import cloud.agileframework.spring.util.ServletUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-2147483648)
@ControllerAdvice
public class SpringExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(SpringExceptionHandler.class);
    private static final String MESSAGE_HEAD = "\u7edf\u4e00\u5f02\u5e38\u6355\u6349";

    @ExceptionHandler(value={Throwable.class})
    public ModelAndView allExceptionHandler(Throwable e) {
        return SpringExceptionHandler.createModelAndView(e);
    }

    public static ModelAndView createModelAndView(Throwable e) {
        ModelAndView modelAndView;
        RETURN r;
        Object attributeErrors;
        if (e instanceof AgileArgumentException && (attributeErrors = ServletUtil.getCurrentRequest().getAttribute("$cloud.agileframework.attributeError")) != null) {
            return ViewUtil.getResponseFormatData(new Head(RETURN.PARAMETER_ERROR), attributeErrors);
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        if ((r = SpringExceptionHandler.to(e)).getStatus() == HttpStatus.INTERNAL_SERVER_ERROR) {
            e.printStackTrace();
            logger.error(MESSAGE_HEAD, e);
        }
        Head head = new Head(r);
        AbstractResponseFormat abstractResponseFormat = (AbstractResponseFormat)BeanUtil.getBean(AbstractResponseFormat.class);
        if (abstractResponseFormat != null) {
            modelAndView = abstractResponseFormat.buildResponse(head, null);
        } else {
            modelAndView = new ModelAndView();
            modelAndView.addObject("head", (Object)head);
            modelAndView.addObject("result", null);
        }
        modelAndView.setStatus(head.getStatus());
        return modelAndView;
    }

    private static RETURN to(Throwable e) {
        String message;
        if (e instanceof AbstractCustomException) {
            message = MessageUtil.message((String)e.getClass().getName(), (Object[])((AbstractCustomException)e).getParams());
        } else {
            if (e instanceof NoSuchRequestServiceException || e instanceof NoSuchRequestMethodException) {
                return RETURN.NOT_FOUND;
            }
            message = MessageUtil.message((String)e.getClass().getName(), (Object[])new Object[]{e.getMessage()});
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            return RETURN.of(RETURN.FAIL.getCode(), RETURN.FAIL.getMsg(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        String codePrefix = "^[\\d]{6}";
        if (PatternUtil.find((String)"^[\\d]{6}", (String)message) && !message.startsWith("2")) {
            return RETURN.byMessage(HttpStatus.OK, message);
        }
        return RETURN.byMessage(HttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        return SpringExceptionHandler.createModelAndView(ex);
    }
}

