/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.param;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.mvc.base.AbstractResponseFormat;
import cloud.agileframework.mvc.base.Head;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.spring.util.BeanUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.web.servlet.ModelAndView;

public class AgileReturn {
    private static final ThreadLocal<Head> HEAD = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> OBJECT = ThreadLocal.withInitial(LinkedHashMap::new);
    private static final ThreadLocal<Boolean> IS_INIT = ThreadLocal.withInitial(() -> Boolean.FALSE);

    private AgileReturn() {
    }

    public static void init(RETURN r, Object object) {
        AgileReturn.init(new Head(r), object);
    }

    public static void init(Head head, Object object) {
        AgileReturn.clear();
        HEAD.set(head);
        AgileReturn.setBody(object);
    }

    public static boolean isInit() {
        return IS_INIT.get();
    }

    public static void add(String key, Object value) {
        IS_INIT.set(true);
        OBJECT.get().put(key, value);
    }

    public static void add(Object value) {
        IS_INIT.set(true);
        if (Map.class.isAssignableFrom(value.getClass())) {
            OBJECT.get().putAll((Map)value);
        } else if (value instanceof String || ClassUtil.isWrapOrPrimitive(value.getClass())) {
            OBJECT.get().put("result", value);
        } else {
            Map map = (Map)ObjectUtil.to((Object)value, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (map == null) {
                OBJECT.get().put("result", value);
            } else {
                OBJECT.get().putAll(map);
            }
        }
    }

    public static void setHead(RETURN r) {
        IS_INIT.set(true);
        AgileReturn.setHead(new Head(r));
    }

    private static void setHead(Head head) {
        IS_INIT.set(true);
        HEAD.set(head);
    }

    private static void setBody(Object object) {
        OBJECT.get().clear();
        AgileReturn.add(object);
    }

    public static Head getHead() {
        Head head = HEAD.get();
        if (head == null) {
            AgileReturn.setHead(RETURN.SUCCESS);
            return HEAD.get();
        }
        return head;
    }

    public static Map<String, Object> getBody() {
        return OBJECT.get();
    }

    public static ModelAndView build() {
        ModelAndView modelAndView = new ModelAndView();
        AbstractResponseFormat abstractResponseFormat = (AbstractResponseFormat)BeanUtil.getBean(AbstractResponseFormat.class);
        if (abstractResponseFormat != null) {
            modelAndView = abstractResponseFormat.buildResponse(AgileReturn.getHead(), AgileReturn.getBody());
        } else {
            if (AgileReturn.getHead() != null) {
                modelAndView.addObject("head", (Object)AgileReturn.getHead());
                modelAndView.setStatus(AgileReturn.getHead().getStatus());
            }
            if (AgileReturn.getBody() != null) {
                modelAndView.addAllObjects(AgileReturn.getBody());
            } else {
                modelAndView.addObject("result", AgileReturn.getBody());
            }
        }
        AgileReturn.clear();
        return modelAndView;
    }

    public static void clear() {
        HEAD.remove();
        OBJECT.remove();
        IS_INIT.remove();
    }
}

