/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.util;

import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.NotAPI;
import cloud.agileframework.mvc.container.AgileHandlerMapping;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.MappingUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ApiUtil {
    private static final Map<String, RequestMappingInfo> API_INFO_CACHE = new HashMap<String, RequestMappingInfo>();

    public static RequestMappingInfo getApiCache(HttpServletRequest request) {
        HandlerMethod handlerMethod = MappingUtil.matching((HttpServletRequest)request);
        return API_INFO_CACHE.get(handlerMethod.getMethod().toGenericString());
    }

    public static void registerApiMapping(String beanName, Object bean) {
        Method[] methods;
        Class<?> realClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (realClass == Class.class) {
            realClass = bean.getClass();
        }
        if (realClass == null || realClass.getAnnotation(NotAPI.class) != null) {
            return;
        }
        AgileService agileService = (AgileService)AnnotationUtils.findAnnotation(realClass, AgileService.class);
        if (agileService == null) {
            return;
        }
        for (Method method : methods = realClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getAnnotation(NotAPI.class) != null) continue;
            ApiUtil.registerApiMapping(bean, method, realClass);
        }
    }

    private static void registerApiMapping(Object bean, Method method, Class<?> clazz) {
        AgileHandlerMapping agileHandlerMapping = (AgileHandlerMapping)((Object)BeanUtil.getBean(AgileHandlerMapping.class));
        RequestMappingInfo requestMappingInfo = agileHandlerMapping.getMappingForMethod(method, clazz);
        if (requestMappingInfo != null) {
            agileHandlerMapping.registerHandlerMethod(bean, method, requestMappingInfo);
            API_INFO_CACHE.put(method.toGenericString(), requestMappingInfo);
        }
    }
}

