/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.util;

import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.mvc.base.AbstractResponseFormat;
import cloud.agileframework.mvc.base.Head;
import cloud.agileframework.spring.util.BeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

@Component
public class ViewUtil {
    private static ViewUtil viewUtil;
    @Nullable
    private List<ViewResolver> viewResolvers;
    @Nullable
    private Locale locale;
    @Nullable
    private RequestToViewNameTranslator viewNameTranslator;

    public static void render(Head head, Object result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ViewUtil.render(ViewUtil.getResponseFormatData(head, result), request, response);
    }

    public static ModelAndView getResponseFormatData(Head head, Object result) {
        ModelAndView modelAndView = new ModelAndView();
        AbstractResponseFormat abstractResponseFormat = (AbstractResponseFormat)BeanUtil.getBean(AbstractResponseFormat.class);
        if (abstractResponseFormat != null) {
            modelAndView = abstractResponseFormat.buildResponse(head, result);
        } else {
            if (head != null) {
                modelAndView.addObject("head", (Object)head);
            }
            if (result != null && Map.class.isAssignableFrom(result.getClass())) {
                modelAndView.addAllObjects((Map)result);
            } else {
                modelAndView.addObject("result", result);
            }
        }
        return modelAndView;
    }

    public static void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes(request, response));
        ApplicationContext context = BeanUtil.getApplicationContext();
        if (ViewUtil.viewUtil.locale == null) {
            ViewUtil.initLocaleResolver(context, request);
        }
        if (ViewUtil.viewUtil.viewResolvers == null) {
            ViewUtil.initViewResolvers(context);
        }
        if (ViewUtil.viewUtil.viewNameTranslator == null) {
            ViewUtil.initRequestToViewNameTranslator(context);
        }
        response.setLocale(ViewUtil.viewUtil.locale);
        String viewName = mv.getViewName();
        if (viewName == null) {
            viewName = ViewUtil.getDefaultViewName(request);
            mv.setViewName(viewName);
        }
        View view = ViewUtil.resolveViewName(viewName, mv.getModel(), ViewUtil.viewUtil.locale, request);
        if (mv.getStatus() != null) {
            response.setStatus(mv.getStatus().value());
        }
        view.render(mv.getModel(), request, response);
    }

    @Nullable
    private static View resolveViewName(String viewName, @Nullable Map<String, Object> model, Locale locale, HttpServletRequest request) throws Exception {
        if (ViewUtil.viewUtil.viewResolvers != null) {
            for (ViewResolver viewResolver : ViewUtil.viewUtil.viewResolvers) {
                View view = viewResolver.resolveViewName(viewName, locale);
                if (view == null) continue;
                return view;
            }
        }
        return null;
    }

    private static void initLocaleResolver(ApplicationContext context, HttpServletRequest request) throws IOException {
        List<LocaleResolver> localeResolvers = ViewUtil.getDefaultStrategies(context, LocaleResolver.class);
        ViewUtil.viewUtil.locale = localeResolvers.size() > 0 ? localeResolvers.get(0).resolveLocale(request) : request.getLocale();
    }

    private static void initViewResolvers(ApplicationContext context) throws IOException {
        ViewUtil.viewUtil.viewResolvers = null;
        Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, ViewResolver.class, (boolean)true, (boolean)false);
        if (!matchingBeans.isEmpty()) {
            ViewUtil.viewUtil.viewResolvers = new LinkedList(matchingBeans.values());
            AnnotationAwareOrderComparator.sort(ViewUtil.viewUtil.viewResolvers);
        }
        if (ViewUtil.viewUtil.viewResolvers == null) {
            ViewUtil.viewUtil.viewResolvers = ViewUtil.getDefaultStrategies(context, ViewResolver.class);
        }
    }

    private static void initRequestToViewNameTranslator(ApplicationContext context) throws IOException {
        try {
            ViewUtil.viewUtil.viewNameTranslator = (RequestToViewNameTranslator)context.getBean("viewNameTranslator", RequestToViewNameTranslator.class);
        }
        catch (NoSuchBeanDefinitionException var3) {
            ViewUtil.viewUtil.viewNameTranslator = ViewUtil.getDefaultStrategies(context, RequestToViewNameTranslator.class).get(0);
        }
    }

    private static <T> List<T> getDefaultStrategies(ApplicationContext context, Class<T> strategyInterface) throws IOException {
        String key = strategyInterface.getName();
        ClassPathResource resource = new ClassPathResource("DispatcherServlet.properties", DispatcherServlet.class);
        Properties defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        String value = defaultStrategies.getProperty(key);
        if (value == null) {
            return new LinkedList();
        }
        String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
        ArrayList<Object> strategies = new ArrayList<Object>(classNames.length);
        String[] var7 = classNames;
        int var8 = classNames.length;
        for (int var9 = 0; var9 < var8; ++var9) {
            String className = var7[var9];
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)DispatcherServlet.class.getClassLoader());
                Object strategy = context.getAutowireCapableBeanFactory().createBean(clazz);
                strategies.add(strategy);
                continue;
            }
            catch (ClassNotFoundException var13) {
                throw new BeanInitializationException("Could not find DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)var13);
            }
            catch (LinkageError var14) {
                throw new BeanInitializationException("Unresolvable class definition for DispatcherServlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)var14);
            }
        }
        return strategies;
    }

    @Nullable
    private static String getDefaultViewName(HttpServletRequest request) throws Exception {
        return ViewUtil.viewUtil.viewNameTranslator != null ? ViewUtil.viewUtil.viewNameTranslator.getViewName(request) : null;
    }

    public static List<Object> extractFiles(Map<String, Object> model) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            Object value = entry.getValue();
            if (FileUtil.isFile((Object)value)) {
                result.add(value);
                continue;
            }
            if (value == null || !Map.class.isAssignableFrom(value.getClass())) continue;
            result.addAll(ViewUtil.extractFiles((Map)value));
        }
        return result;
    }

    @PostConstruct
    public static void init() {
        viewUtil = new ViewUtil();
    }
}

