/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.view;

import cloud.agileframework.mvc.view.ForwardView;
import java.util.Locale;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.RedirectView;

public class JumpViewResolver
extends AbstractCachingViewResolver
implements Ordered {
    private static final String REDIRECT_URL_PREFIX = "redirect:";
    private static final String FORWARD_URL_PREFIX = "forward:";

    public int getOrder() {
        return 0;
    }

    protected View loadView(String viewName, Locale locale) {
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String forwardUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            RedirectView view = new RedirectView(forwardUrl, true, true);
            return this.applyLifecycleMethods(viewName, (AbstractUrlBasedView)view);
        }
        if (viewName.startsWith(FORWARD_URL_PREFIX)) {
            String forwardUrl = viewName.substring(FORWARD_URL_PREFIX.length());
            return new ForwardView(forwardUrl);
        }
        return null;
    }

    private View applyLifecycleMethods(String viewName, AbstractUrlBasedView view) {
        ApplicationContext context = this.getApplicationContext();
        Object initialized = context.getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
        if (initialized instanceof View) {
            return (View)initialized;
        }
        return view;
    }
}

