/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.view;

import cloud.agileframework.common.util.clazz.ClassUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

public class PlainView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private final Integer byteSize = 1024;

    public PlainView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.byteSize);
        if (model.containsKey("result")) {
            Object r = model.get("result");
            if (r instanceof Map) {
                for (Object value : ((Map)r).values()) {
                    if (!ClassUtil.isPrimitiveOrWrapper(value.getClass()) && !(value instanceof String)) continue;
                    baos.write(value.toString().getBytes(response.getCharacterEncoding()));
                }
            } else if (r instanceof String) {
                baos.write(r.toString().getBytes(response.getCharacterEncoding()));
            }
        }
        response.setContentType("text/html");
        response.setContentLength(baos.size());
        baos.writeTo((OutputStream)response.getOutputStream());
    }
}

