/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.filter;

import cloud.agileframework.common.util.string.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class CorsFilter
extends OncePerRequestFilter
implements Filter {
    private String allowOrigin;
    private String allowMethods;
    private String allowCredentials;
    private String allowHeaders;
    private String exposeHeaders;
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.allowOrigin.equals("*") || StringUtil.isEmpty((CharSequence)this.allowOrigin)) {
            httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, this.allowOrigin);
        } else {
            String currentOrigin;
            List<String> allowOriginList = Arrays.asList(this.allowOrigin.split(","));
            if (allowOriginList.contains(currentOrigin = httpServletRequest.getHeader("Origin"))) {
                httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, currentOrigin.replaceAll("\\s", ""));
            }
        }
        if (StringUtil.isNotEmpty((CharSequence)this.allowOrigin)) {
            httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, this.allowOrigin.replaceAll("\\s", ""));
        }
        if (StringUtil.isNotEmpty((CharSequence)this.allowMethods)) {
            httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_METHODS, this.allowMethods.replaceAll("\\s", ""));
        }
        if (StringUtil.isNotEmpty((CharSequence)this.allowCredentials)) {
            httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, this.allowCredentials.replaceAll("\\s", ""));
        }
        if (StringUtil.isNotEmpty((CharSequence)this.allowHeaders)) {
            httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, this.allowHeaders.replaceAll("\\s", ""));
        }
        if (StringUtil.isNotEmpty((CharSequence)this.exposeHeaders)) {
            httpServletResponse.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, this.exposeHeaders.replaceAll("\\s", ""));
        }
        if (RequestMethod.OPTIONS.name().equalsIgnoreCase(httpServletRequest.getMethod())) {
            httpServletResponse.setStatus(200);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void setAllowOrigin(String allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    public void setAllowMethods(String allowMethods) {
        this.allowMethods = allowMethods;
    }

    public void setAllowCredentials(String allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setAllowHeaders(String allowHeaders) {
        this.allowHeaders = allowHeaders;
    }

    public void setExposeHeaders(String exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }
}

