/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.mvc.controller;

import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.mvc.annotation.ApiMethod;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.annotation.NotAPI;
import cloud.agileframework.mvc.base.AbstractResponseFormat;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.exception.NoSuchRequestMethodException;
import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.exception.SpringExceptionHandler;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.mvc.provider.ValidationHandlerProvider;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.MappingUtil;
import cloud.agileframework.spring.util.ServletUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MainController {
    private static final ThreadLocal<Object> SERVICE = new ThreadLocal();
    private static final ThreadLocal<Method> METHOD = new ThreadLocal();
    private final LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    @Autowired
    private WebMvcProperties webMvcProperties;
    @Autowired
    private ObjectProvider<ValidationHandlerProvider> validationHandlerProviders;
    @Autowired
    private ObjectProvider<HandlerMethodArgumentResolver> handlerMethodArgumentResolvers;

    @ResponseBody
    @RequestMapping(value={"/", "/*", "/*/*/*/**"})
    public Object othersProcessor(HttpServletRequest request) throws NoSuchRequestServiceException {
        if (this.initApiInfoByRequestMapping(request)) {
            throw new NoSuchRequestServiceException();
        }
        return this.getModelAndViewWebAsyncTask();
    }

    private WebAsyncTask<ModelAndView> getModelAndViewWebAsyncTask() {
        Object bean = MainController.getService();
        Method method = MainController.getMethod();
        return this.asyncProcessor(() -> {
            try {
                return this.processor(bean, method);
            }
            catch (Throwable e) {
                return SpringExceptionHandler.createModelAndView(e);
            }
        });
    }

    @RequestMapping(value={"/${agile.module-name:api}/{agileInParamService}/{agileInParamMethod}", "/${agile.module-name:api}/{agileInParamService}/{agileInParamMethod}/**", "/{agileInParamService}/{agileInParamMethod}"})
    public Object proxyProcessor(HttpServletRequest request, @PathVariable(value="agileInParamService") String service, @PathVariable(value="agileInParamMethod") String method) throws NoSuchRequestServiceException, NoSuchRequestMethodException {
        this.initApiInfoByRequestMapping(request, service, method);
        return this.getModelAndViewWebAsyncTask();
    }

    private WebAsyncTask<ModelAndView> asyncProcessor(Callable<ModelAndView> callable) {
        Duration timeout = this.webMvcProperties.getAsync().getRequestTimeout();
        if (timeout == null) {
            timeout = Duration.ofSeconds(15L);
        }
        WebAsyncTask asyncTask = new WebAsyncTask(timeout.toMillis(), callable);
        Duration finalTimeout = timeout;
        asyncTask.onTimeout(() -> SpringExceptionHandler.createModelAndView(new InterruptedException(String.format("\u8bf7\u6c42\u8d85\u65f6\uff0c\u6700\u957f\u8fc7\u671f\u65f6\u95f4%s", finalTimeout.toString()))));
        return asyncTask;
    }

    private ModelAndView processor(Object bean, Method method) throws Throwable {
        List validationHandlerProviderList = this.validationHandlerProviders.orderedStream().collect(Collectors.toList());
        for (ValidationHandlerProvider validationHandlerProvider : validationHandlerProviderList) {
            validationHandlerProvider.before(ServletUtil.getCurrentRequest(), ServletUtil.getCurrentResponse(), method);
        }
        ((MainController)BeanUtil.getBean(this.getClass())).invoke(bean, method);
        ModelAndView modelAndView = AgileReturn.build();
        MainController.clear();
        return modelAndView;
    }

    public static void clear() {
        SERVICE.remove();
        METHOD.remove();
        AgileReturn.clear();
    }

    private boolean dontAllowRequestMethod(RequestMethod[] requestMethods, RequestMethod requestMethod) {
        if (requestMethod == null) {
            return true;
        }
        return requestMethods != null && requestMethods.length != 0 && !ArrayUtils.contains((Object[])requestMethods, (Object)requestMethod);
    }

    private boolean initApiInfoByRequestMapping(HttpServletRequest currentRequest) {
        HandlerMethod handlerMethod = MappingUtil.matching((HttpServletRequest)currentRequest);
        if (handlerMethod != null && !(handlerMethod.getBean() instanceof MainController)) {
            Object bean = handlerMethod.getBean();
            Method targetMethod = handlerMethod.getMethod();
            MainController.initServiceByObject(bean);
            MainController.initMethodByObject(targetMethod);
            return false;
        }
        return true;
    }

    private boolean initApiInfoByRequestMapping(HttpServletRequest request, String service, String method) throws NoSuchRequestServiceException, NoSuchRequestMethodException {
        if (this.initApiInfoByRequestMapping(request)) {
            MainController.initService(StringUtil.toLowerName((String)service));
            this.initMethod(StringUtil.toLowerName((String)method));
            return false;
        }
        return true;
    }

    private static void initServiceByObject(Object o) {
        SERVICE.set(o);
    }

    private static void initService(String serviceName) throws NoSuchRequestServiceException {
        Object o = BeanUtil.getBean((String)serviceName);
        if (o == null) {
            throw new NoSuchRequestServiceException();
        }
        SERVICE.set(o);
    }

    private static void initMethodByObject(Method o) {
        METHOD.set(o);
    }

    private void initMethod(String methodName) throws NoSuchRequestMethodException {
        Method methodCache = ClassInfo.getCache(MainController.getService().getClass()).getAllMethod().stream().filter(m -> methodName.endsWith(m.getName()) && Modifier.isPublic(m.getModifiers())).findFirst().orElse(null);
        if (methodCache == null) {
            throw new NoSuchRequestMethodException();
        }
        if (methodCache.getDeclaringClass().getAnnotation(NotAPI.class) != null || methodCache.getAnnotation(NotAPI.class) != null) {
            throw new NoSuchRequestMethodException();
        }
        RequestMethod currentRequestMethod = RequestMethod.valueOf((String)ServletUtil.getCurrentRequest().getMethod());
        Mapping requestMapping = methodCache.getAnnotation(Mapping.class);
        if (requestMapping != null && this.dontAllowRequestMethod(requestMapping.method(), currentRequestMethod)) {
            throw new NoSuchRequestMethodException();
        }
        ApiMethod apiMethod = methodCache.getAnnotation(ApiMethod.class);
        if (apiMethod != null && this.dontAllowRequestMethod(apiMethod.value(), currentRequestMethod)) {
            throw new NoSuchRequestMethodException();
        }
        METHOD.set(methodCache);
    }

    private static Object getService() {
        return SERVICE.get();
    }

    @Transactional(rollbackFor={Exception.class})
    public void invoke(Object bean, Method method) throws Throwable {
        try {
            Object returnData;
            int count = method.getParameterCount();
            if (count > 0) {
                Object[] args = new Object[count];
                IntStream.range(0, count).forEach(index -> {
                    MethodParameter methodParameter = new MethodParameter(method, index);
                    methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)this.localVariableTableParameterNameDiscoverer);
                    args[index] = this.handlerMethodArgumentResolvers.orderedStream().filter(resolver -> resolver.supportsParameter(methodParameter)).map(resolver -> {
                        try {
                            return resolver.resolveArgument(methodParameter, new ModelAndViewContainer(), (NativeWebRequest)new ServletWebRequest(ServletUtil.getCurrentRequest(), ServletUtil.getCurrentResponse()), null);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).findFirst().orElse(null);
                });
                returnData = method.invoke(bean, args);
            } else {
                returnData = method.invoke(bean, new Object[0]);
            }
            if (returnData instanceof RETURN) {
                AgileReturn.setHead((RETURN)returnData);
            } else if (returnData instanceof AbstractResponseFormat) {
                ((AbstractResponseFormat)returnData).initAgileReturn();
            } else if (returnData != null) {
                AgileReturn.add(returnData);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private static Method getMethod() {
        return METHOD.get();
    }
}

