/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.config;

import cloud.agileframework.mvc.container.AgileHandlerMapping;
import cloud.agileframework.mvc.container.AgileHandlerMethodArgumentResolver;
import cloud.agileframework.mvc.container.CustomAsyncHandlerInterceptor;
import cloud.agileframework.mvc.container.CustomHandlerInterceptor;
import cloud.agileframework.mvc.container.CustomHandlerMethodReturnValueHandler;
import cloud.agileframework.mvc.container.FileHandlerMethodReturnValueHandler;
import cloud.agileframework.mvc.container.ReturnHandlerMethodReturnValueHandler;
import cloud.agileframework.mvc.filter.CorsFilter;
import cloud.agileframework.mvc.filter.RequestWrapperFilter;
import cloud.agileframework.mvc.properties.CorsFilterProperties;
import cloud.agileframework.mvc.provider.ArgumentInitHandlerProvider;
import cloud.agileframework.mvc.provider.ArgumentValidationHandlerProvider;
import cloud.agileframework.mvc.view.FileViewResolver;
import cloud.agileframework.spring.util.BeanUtil;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.fastjson.support.spring.FastJsonJsonView;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.TimeoutCallableProcessingInterceptor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={TaskExecutionProperties.class, CorsFilterProperties.class, WebMvcProperties.class})
public class SpringMvcAutoConfiguration
implements WebMvcConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CorsFilterProperties corsFilterProperties;
    private final WebMvcProperties webMvcProperties;
    private final TaskExecutionProperties taskExecutionProperties;

    @Autowired
    public SpringMvcAutoConfiguration(CorsFilterProperties corsFilterProperties, WebMvcProperties webMvcProperties, TaskExecutionProperties taskExecutionProperties) {
        this.corsFilterProperties = corsFilterProperties;
        this.webMvcProperties = webMvcProperties;
        this.taskExecutionProperties = taskExecutionProperties;
    }

    @Bean
    @ConditionalOnClass(value={CorsFilter.class})
    public FilterRegistrationBean<CorsFilter> corsFilter() {
        FilterRegistrationBean corsFilter = new FilterRegistrationBean();
        corsFilter.setFilter((Filter)new CorsFilter());
        corsFilter.addUrlPatterns(new String[]{"/*"});
        corsFilter.addInitParameter("allowOrigin", this.corsFilterProperties.getAllowOrigin());
        corsFilter.addInitParameter("allowMethods", this.corsFilterProperties.getAllowMethods());
        corsFilter.addInitParameter("allowCredentials", Boolean.toString(this.corsFilterProperties.isAllowCredentials()));
        corsFilter.addInitParameter("allowHeaders", this.corsFilterProperties.getAllowHeaders());
        corsFilter.addInitParameter("exposeHeaders", this.corsFilterProperties.getExposeHeaders());
        this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316\u8de8\u57df\u8fc7\u6ee4\u5668");
        return corsFilter;
    }

    @Bean
    @ConditionalOnClass(value={RequestWrapperFilter.class})
    public FilterRegistrationBean<RequestWrapperFilter> requestWrapperFilter() {
        FilterRegistrationBean requestFilter = new FilterRegistrationBean();
        requestFilter.setFilter((Filter)new RequestWrapperFilter());
        requestFilter.addUrlPatterns(new String[]{"/*"});
        this.logger.debug("\u5b8c\u6210\u521d\u59cb\u5316Request\u5305\u88c5\u8fc7\u6ee4\u5668");
        return requestFilter;
    }

    @Bean
    @Order(value=-2147483648)
    public AgileHandlerMapping agileHandlerMapping() {
        return new AgileHandlerMapping();
    }

    @Bean
    ArgumentInitHandlerProvider argumentInitHandlerProvider() {
        return new ArgumentInitHandlerProvider();
    }

    @Bean
    ArgumentValidationHandlerProvider argumentValidationHandlerProvider() {
        return new ArgumentValidationHandlerProvider();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(this.agileHandlerMethodArgumentResolver());
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        registry.viewResolver((ViewResolver)new FileViewResolver());
        registry.enableContentNegotiation(new View[]{this.fastJsonView()});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        FastJsonConfig config = this.getFastJsonConfig();
        converter.setFastJsonConfig(config);
        converter.setDefaultCharset(StandardCharsets.UTF_8);
        ArrayList<MediaType> mediaTypeList = new ArrayList<MediaType>();
        mediaTypeList.add(MediaType.APPLICATION_JSON);
        converter.setSupportedMediaTypes(mediaTypeList);
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)converter);
    }

    private FastJsonConfig getFastJsonConfig() {
        FastJsonConfig config = new FastJsonConfig();
        SerializeConfig serializeConfig = SerializeConfig.globalInstance;
        serializeConfig.put(BigInteger.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        config.setSerializeConfig(serializeConfig);
        config.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.PrettyFormat, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect});
        config.setDateFormat(this.webMvcProperties.getFormat().getDateTime());
        return config;
    }

    private FastJsonJsonView fastJsonView() {
        FastJsonJsonView fastJsonView = new FastJsonJsonView();
        FastJsonConfig fastJsonConfig = this.getFastJsonConfig();
        fastJsonView.setFastJsonConfig(fastJsonConfig);
        return fastJsonView;
    }

    @Bean
    AgileHandlerMethodArgumentResolver agileHandlerMethodArgumentResolver() {
        return new AgileHandlerMethodArgumentResolver();
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> handlers) {
        handlers.add(new CustomHandlerMethodReturnValueHandler());
        handlers.add((HandlerMethodReturnValueHandler)new ReturnHandlerMethodReturnValueHandler());
        handlers.add(new FileHandlerMethodReturnValueHandler());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new CustomHandlerInterceptor());
        registry.addInterceptor((HandlerInterceptor)this.customAsyncHandlerInterceptor());
    }

    @Bean
    CustomAsyncHandlerInterceptor customAsyncHandlerInterceptor() {
        return new CustomAsyncHandlerInterceptor();
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        Duration timeout = this.webMvcProperties.getAsync().getRequestTimeout();
        if (timeout == null) {
            timeout = Duration.ofSeconds(3L);
        }
        configurer.setDefaultTimeout(timeout.toMillis());
        CallableProcessingInterceptor timeoutInterceptor = (CallableProcessingInterceptor)BeanUtil.getBean(CallableProcessingInterceptor.class);
        configurer.registerCallableInterceptors(new CallableProcessingInterceptor[]{timeoutInterceptor});
        ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)BeanUtil.getBean(ThreadPoolTaskExecutor.class);
        configurer.setTaskExecutor((AsyncTaskExecutor)threadPoolTaskExecutor);
    }

    @Bean
    @ConditionalOnMissingBean(value={CallableProcessingInterceptor.class})
    public TimeoutCallableProcessingInterceptor timeoutInterceptor() {
        return new TimeoutCallableProcessingInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={ThreadPoolTaskExecutor.class})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor t = new ThreadPoolTaskExecutor();
        t.setCorePoolSize(this.taskExecutionProperties.getPool().getCoreSize());
        t.setMaxPoolSize(this.taskExecutionProperties.getPool().getMaxSize());
        t.setQueueCapacity(this.taskExecutionProperties.getPool().getQueueCapacity());
        t.setThreadNamePrefix(this.taskExecutionProperties.getThreadNamePrefix());
        return t;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.setOrder(Integer.MIN_VALUE);
    }
}

