/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.listener;

import cloud.agileframework.mvc.container.AgileBanner;
import java.util.Properties;
import org.springframework.boot.Banner;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;

public class ListenerSpringApplicationRun
implements SpringApplicationRunListener {
    private final SpringApplication application;
    private static Long startTime;

    public ListenerSpringApplicationRun(SpringApplication application, String[] args) {
        this.application = application;
        Properties properties = new Properties();
        properties.setProperty("spring.mvc.static-path-pattern", "/static/**");
        application.setDefaultProperties(properties);
    }

    public void starting(ConfigurableBootstrapContext bootstrapContext) {
        super.starting(bootstrapContext);
        startTime = System.currentTimeMillis();
        this.application.setBanner((Banner)new AgileBanner());
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        exception.printStackTrace();
    }

    public static long getConsume() {
        return System.currentTimeMillis() - startTime;
    }
}

