/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.mvc.controller;

import cloud.agileframework.mvc.base.AbstractResponseFormat;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.spring.util.ServletUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.IntStream;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AgileServiceProxy {
    private final LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    @Autowired
    private ObjectProvider<HandlerMethodArgumentResolver> handlerMethodArgumentResolvers;

    @Transactional(rollbackFor={Exception.class})
    public void invoke(Object bean, Method method) throws Throwable {
        try {
            Object returnData;
            int count = method.getParameterCount();
            if (count > 0) {
                Object[] args = new Object[count];
                IntStream.range(0, count).forEach(index -> {
                    MethodParameter methodParameter = new MethodParameter(method, index);
                    methodParameter.initParameterNameDiscovery((ParameterNameDiscoverer)this.localVariableTableParameterNameDiscoverer);
                    args[index] = this.handlerMethodArgumentResolvers.orderedStream().filter(resolver -> resolver.supportsParameter(methodParameter)).map(resolver -> {
                        try {
                            return resolver.resolveArgument(methodParameter, new ModelAndViewContainer(), (NativeWebRequest)new ServletWebRequest(ServletUtil.getCurrentRequest(), ServletUtil.getCurrentResponse()), null);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).findFirst().orElse(null);
                });
                returnData = method.invoke(bean, args);
            } else {
                returnData = method.invoke(bean, new Object[0]);
            }
            if (returnData instanceof RETURN) {
                AgileReturn.setHead((RETURN)returnData);
            } else if (returnData instanceof AbstractResponseFormat) {
                ((AbstractResponseFormat)returnData).initAgileReturn();
            } else if (returnData != null) {
                AgileReturn.add(returnData);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

