/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.provider;

import cloud.agileframework.mvc.provider.HandlerProvider;
import cloud.agileframework.mvc.util.ApiUtil;
import cloud.agileframework.spring.util.RequestWrapper;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ArgumentInitHandlerProvider
implements HandlerProvider {
    private static Map<String, Object> parseUriVariable(HttpServletRequest currentRequest) {
        HashMap uriVariables = Maps.newHashMap();
        String uri = currentRequest.getRequestURI();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        RequestMappingInfo requestMappingInfo = ApiUtil.getApiCache(currentRequest);
        if (requestMappingInfo == null) {
            Map map = (Map)currentRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (map != null) {
                return map;
            }
            return uriVariables;
        }
        PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
        if (patternsCondition != null) {
            for (String mapping : patternsCondition.getPatterns()) {
                try {
                    uriVariables.putAll(new AntPathMatcher().extractUriTemplateVariables(mapping, uri));
                }
                catch (Exception exception) {}
            }
        }
        return uriVariables;
    }

    @Override
    public void before(HttpServletRequest request, HttpServletResponse response, Method method) throws Exception {
        RequestWrapper requestWrapper = RequestWrapper.extract((HttpServletRequest)request);
        requestWrapper.extendInParam(ArgumentInitHandlerProvider.parseUriVariable(request));
    }
}

