/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.util;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.mvc.annotation.AgileService;
import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.mvc.container.AgileHandlerMapping;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.MappingUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class ApiUtil {
    private static final Map<String, RequestMappingInfo> API_INFO_CACHE = new HashMap<String, RequestMappingInfo>();

    private static String toCacheKey(HandlerMethod handlerMethod) {
        return ApiUtil.toCacheKey(handlerMethod.getBean(), handlerMethod.getMethod());
    }

    private static String toCacheKey(Object bean, Method method) {
        String className = bean.getClass().getName();
        String methodName = method.toGenericString();
        return String.format("%s_%s", className, methodName);
    }

    public static RequestMappingInfo getApiCache(HttpServletRequest request) {
        HandlerMethod handlerMethod = MappingUtil.matching((HttpServletRequest)request);
        return API_INFO_CACHE.get(ApiUtil.toCacheKey(handlerMethod));
    }

    public static void registerApiMapping(Object bean) {
        AgileService agileService;
        Class<?> realClass = BeanUtil.getBeanClass((Object)bean);
        if (realClass == Class.class) {
            realClass = bean.getClass();
        }
        if ((agileService = (AgileService)AnnotationUtils.findAnnotation(realClass, AgileService.class)) == null) {
            return;
        }
        Set methods = ClassUtil.getAllMethod(realClass);
        for (Method method : methods) {
            if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Mapping.class) == null || !Modifier.isPublic(method.getModifiers()) || method.isBridge()) continue;
            ApiUtil.registerApiMapping(bean, method, realClass);
        }
    }

    private static void registerApiMapping(Object bean, Method method, Class<?> clazz) {
        AgileHandlerMapping agileHandlerMapping = (AgileHandlerMapping)((Object)BeanUtil.getBean(AgileHandlerMapping.class));
        RequestMappingInfo requestMappingInfo = agileHandlerMapping.getMappingForMethod(method, clazz);
        if (requestMappingInfo != null) {
            agileHandlerMapping.registerHandlerMethod(bean, method, requestMappingInfo);
            API_INFO_CACHE.put(ApiUtil.toCacheKey(bean, method), requestMappingInfo);
        }
    }
}

