/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.annotation;

import cloud.agileframework.mvc.annotation.Parsing;
import cloud.agileframework.mvc.annotation.ParsingBeanAfter;
import cloud.agileframework.mvc.annotation.ParsingBeanBefore;
import cloud.agileframework.mvc.annotation.ParsingMethodAfter;
import cloud.agileframework.mvc.annotation.ParsingMethodBefore;
import cloud.agileframework.spring.util.BeanUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public class AnnotationProcessor {
    private AnnotationProcessor() {
    }

    public static void methodAnnotationProcessor(ApplicationContext applicationContext, String beanName, Class<?> annotationClass) {
        String[] annotationParsings;
        for (String parsingName : annotationParsings = applicationContext.getBeanNamesForType(annotationClass)) {
            Parsing parsing = (Parsing)applicationContext.getBean(parsingName);
            Class<? extends Annotation> annotation = parsing.getAnnotation();
            if (annotation == null) continue;
            Object bean = BeanUtil.getApplicationContext().getBean(beanName);
            Class beanClass = BeanUtil.getBeanClass((Object)bean);
            AnnotationProcessor.methodAnnotationProcessor(beanName, beanClass, parsing);
        }
    }

    public static void beanAnnotationProcessor(ApplicationContext applicationContext, Class annotationClass) {
        String[] annotationParsings;
        for (String parsingName : annotationParsings = applicationContext.getBeanNamesForType(annotationClass)) {
            Parsing parsing = (Parsing)applicationContext.getBean(parsingName);
            Class<? extends Annotation> annotation = parsing.getAnnotation();
            if (annotation == null) continue;
            Map beans = applicationContext.getBeansWithAnnotation(annotation);
            for (Map.Entry map : beans.entrySet()) {
                String beanName = (String)map.getKey();
                Object bean = map.getValue();
                if (parsing instanceof ParsingBeanAfter) {
                    ((ParsingBeanAfter)parsing).parsing(beanName, bean);
                    continue;
                }
                if (!(parsing instanceof ParsingBeanBefore)) continue;
                ((ParsingBeanBefore)parsing).parsing(beanName, bean);
            }
        }
    }

    private static void methodAnnotationProcessor(String beanName, Class realClass, Parsing parsing) {
        Method[] methods;
        for (Method method : methods = realClass.getDeclaredMethods()) {
            method.setAccessible(true);
            Class<? extends Annotation> annotation = parsing.getAnnotation();
            if (annotation == null || method.getAnnotation(annotation) == null) continue;
            if (parsing instanceof ParsingMethodAfter) {
                ((ParsingMethodAfter)parsing).parsing(beanName, method);
                continue;
            }
            if (!(parsing instanceof ParsingMethodBefore)) continue;
            ((ParsingMethodBefore)parsing).parsing(beanName, method);
        }
    }
}

