/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.container;

import cloud.agileframework.mvc.annotation.Mapping;
import cloud.agileframework.spring.util.BeanUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class AgileHandlerMapping
extends RequestMappingHandlerMapping {
    private final Map<String, RequestMappingInfo> cache = new HashMap<String, RequestMappingInfo>();

    private RequestMappingInfo createMappingInfo(Mapping mapping, RequestCondition<?> condition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths((String[])this.resolveEmbeddedValuesInPatterns(mapping.path())).methods(mapping.method()).params(mapping.params()).headers(mapping.headers()).consumes(mapping.consumes()).produces(mapping.produces()).mappingName(mapping.name());
        if (condition != null) {
            builder.customCondition(condition);
        }
        return builder.build();
    }

    @Nullable
    private RequestMappingInfo createMappingInfo(AnnotatedElement element) {
        Mapping requestMapping = (Mapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, Mapping.class);
        RequestCondition condition = element instanceof Class ? this.getCustomTypeCondition((Class)element) : this.getCustomMethodCondition((Method)element);
        return requestMapping != null ? this.createMappingInfo(requestMapping, condition) : null;
    }

    public RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo typeInfo;
        RequestMappingInfo info = this.createMappingInfo(method);
        if (info != null && (typeInfo = this.createMappingInfo(handlerType)) != null) {
            info = typeInfo.combine(info);
        }
        return info;
    }

    public void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        PatternsRequestCondition patternsCondition = mapping.getPatternsCondition();
        if (patternsCondition == null) {
            return;
        }
        for (String path : patternsCondition.getPatterns()) {
            RequestMappingInfo cacheMapping = this.cache.get(path);
            if (!ObjectUtils.isEmpty((Object)cacheMapping)) {
                Set methods = mapping.getMethodsCondition().getMethods();
                for (RequestMethod requestMethod : cacheMapping.getMethodsCondition().getMethods()) {
                    if (!methods.contains(requestMethod)) continue;
                    String message = String.format("Mapping\u6620\u5c04\u91cd\u590d\uff0c\u91cd\u590d\u7c7b:%s,\u91cd\u590d\u65b9\u6cd5:%s", BeanUtil.getBeanClass((Object)handler).getName(), method.getName());
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)message);
                    }
                    throw new IllegalStateException(message);
                }
            }
            this.cache.put(path, mapping);
        }
        super.registerHandlerMethod(handler, method, mapping);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("[class:%s][method:%s][url:%s]", BeanUtil.getBeanClass((Object)handler).getCanonicalName(), method.getName(), String.join((CharSequence)",", patternsCondition.getPatterns())));
        }
    }
}

