/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.mvc.controller;

import cloud.agileframework.mvc.exception.NoSuchRequestServiceException;
import cloud.agileframework.mvc.exception.SpringExceptionHandler;
import cloud.agileframework.mvc.mvc.controller.AgileServiceProxy;
import cloud.agileframework.mvc.param.AgileReturn;
import cloud.agileframework.mvc.provider.ValidationHandlerProvider;
import cloud.agileframework.spring.util.MappingUtil;
import cloud.agileframework.spring.util.ServletUtil;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MainController {
    @Autowired
    private AgileServiceProxy methodHandler;
    @Autowired
    private WebMvcProperties webMvcProperties;
    @Autowired
    private ObjectProvider<ValidationHandlerProvider> validationHandlerProviders;

    @ResponseBody
    @RequestMapping(value={"/", "/**"})
    public Object othersProcessor(HttpServletRequest request) throws NoSuchRequestServiceException {
        HandlerMethod handlerMethod = MappingUtil.matching((HttpServletRequest)request);
        if (handlerMethod == null || handlerMethod.getBean() instanceof MainController) {
            throw new NoSuchRequestServiceException();
        }
        return this.getModelAndViewWebAsyncTask(handlerMethod);
    }

    private WebAsyncTask<ModelAndView> getModelAndViewWebAsyncTask(HandlerMethod handlerMethod) {
        Object bean = handlerMethod.getBean();
        Method method = handlerMethod.getMethod();
        return this.asyncProcessor(() -> {
            try {
                return this.processor(bean, method);
            }
            catch (Throwable e) {
                return SpringExceptionHandler.createModelAndView(e);
            }
        });
    }

    private WebAsyncTask<ModelAndView> asyncProcessor(Callable<ModelAndView> callable) {
        Duration timeout = this.webMvcProperties.getAsync().getRequestTimeout();
        if (timeout == null) {
            timeout = Duration.ofSeconds(15L);
        }
        WebAsyncTask asyncTask = new WebAsyncTask(timeout.toMillis(), callable);
        Duration finalTimeout = timeout;
        asyncTask.onTimeout(() -> SpringExceptionHandler.createModelAndView(new InterruptedException(String.format("\u8bf7\u6c42\u8d85\u65f6\uff0c\u6700\u957f\u8fc7\u671f\u65f6\u95f4%s", finalTimeout))));
        return asyncTask;
    }

    private ModelAndView processor(Object bean, Method method) throws Throwable {
        List validationHandlerProviderList = this.validationHandlerProviders.orderedStream().collect(Collectors.toList());
        for (ValidationHandlerProvider validationHandlerProvider : validationHandlerProviderList) {
            validationHandlerProvider.before(ServletUtil.getCurrentRequest(), ServletUtil.getCurrentResponse(), method);
        }
        this.methodHandler.invoke(bean, method);
        ModelAndView modelAndView = AgileReturn.build();
        AgileReturn.clear();
        return modelAndView;
    }
}

