/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.param;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.spring.util.RequestWrapper;
import cloud.agileframework.spring.util.ServletUtil;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartFile;

public final class AgileParam {
    private AgileParam() {
    }

    public static Map<String, Object> getInParam() {
        RequestWrapper wrapper = AgileParam.getRequestWrapper();
        return Maps.newHashMap((Map)wrapper.getInParam());
    }

    private static RequestWrapper getRequestWrapper() {
        HttpServletRequest currentRequest = ServletUtil.getCurrentRequest();
        return RequestWrapper.extract((HttpServletRequest)currentRequest);
    }

    public static boolean containsKey(String key) {
        return AgileParam.getRequestWrapper().containsKey(key);
    }

    public static Object getInParam(String key) {
        return AgileParam.getRequestWrapper().getInParam(key);
    }

    public static <T> T getInParam(Class<T> clazz) {
        return (T)AgileParam.getRequestWrapper().getInParam(clazz);
    }

    public static <T> T getInParam(TypeReference<T> typeReference) {
        return (T)AgileParam.getRequestWrapper().getInParam(typeReference);
    }

    public static <T> T getInParamByPrefix(Class<T> clazz, String prefix) {
        return (T)AgileParam.getRequestWrapper().getInParamByPrefix(clazz, prefix);
    }

    public static <T> T getInParamByPrefixAndSuffix(Class<T> clazz, String prefix, String suffix) {
        return (T)AgileParam.getRequestWrapper().getInParamByPrefixAndSuffix(clazz, prefix, suffix);
    }

    public static String getInParam(String key, String defaultValue) {
        return AgileParam.getRequestWrapper().getInParam(key, defaultValue);
    }

    public static <T> T getInParam(String key, Class<T> clazz) {
        return (T)AgileParam.getRequestWrapper().getInParam(key, clazz);
    }

    public static <T> T getInParam(String key, TypeReference<T> reference) {
        return (T)AgileParam.getRequestWrapper().getInParam(key, reference);
    }

    public static <T> T getInParam(String key, Class<T> clazz, T defaultValue) {
        return (T)AgileParam.getRequestWrapper().getInParam(key, clazz, defaultValue);
    }

    public static MultipartFile getInParamOfFile(String key) {
        return AgileParam.getRequestWrapper().getInParamOfFile(key);
    }

    public static List<MultipartFile> getInParamOfFiles(String key) {
        return AgileParam.getRequestWrapper().getInParamOfFiles(key);
    }

    public static List<String> getInParamOfArray(String key) {
        return AgileParam.getRequestWrapper().getInParamOfArray(key);
    }

    public static <T> List<T> getInParamOfArray(String key, Class<T> clazz) {
        return AgileParam.getRequestWrapper().getInParamOfArray(key, clazz);
    }
}

