/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mvc.param;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.mvc.base.AbstractResponseFormat;
import cloud.agileframework.mvc.base.Head;
import cloud.agileframework.mvc.base.RETURN;
import cloud.agileframework.mvc.util.ViewUtil;
import cloud.agileframework.spring.util.BeanUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class AgileReturn {
    private static final ThreadLocal<Head> HEAD = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> BODY = ThreadLocal.withInitial(LinkedHashMap::new);
    private static final ThreadLocal<Map<String, Object>> OTHER = ThreadLocal.withInitial(LinkedHashMap::new);
    private static final ThreadLocal<String> VIEW_NAME = new ThreadLocal();
    private static final ThreadLocal<View> VIEW = new ThreadLocal();

    private AgileReturn() {
    }

    public static void init(RETURN r, Object object) {
        AgileReturn.init(new Head(r), object);
    }

    public static void init(Head head, Object object) {
        AgileReturn.clear();
        HEAD.set(head);
        AgileReturn.setBody(object);
    }

    public static void add(String key, Object value) {
        BODY.get().put(key, value);
    }

    public static void add(Object value) {
        List<Object> files = ViewUtil.extractFiles(value);
        if (!files.isEmpty()) {
            VIEW_NAME.set("file:");
            OTHER.get().put("$AGILE_FILE_ATTRIBUTE_NAME", files);
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            BODY.get().putAll((Map)value);
        } else if (value instanceof String || ClassUtil.isWrapOrPrimitive(value.getClass())) {
            BODY.get().put("result", value);
        } else {
            Map map = (Map)ObjectUtil.to((Object)value, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (map == null) {
                BODY.get().put("result", value);
            } else {
                BODY.get().putAll(map);
            }
        }
    }

    public static void setHead(RETURN r) {
        HEAD.set(new Head(r));
    }

    private static void setBody(Object object) {
        BODY.get().clear();
        AgileReturn.add(object);
    }

    public static Head getHead() {
        Head head = HEAD.get();
        if (head == null) {
            AgileReturn.setHead(RETURN.SUCCESS);
            return HEAD.get();
        }
        return head;
    }

    public static Map<String, Object> getBody() {
        return BODY.get();
    }

    public static void setViewName(String viewName) {
        VIEW_NAME.set(viewName);
    }

    public static String getViewName() {
        return VIEW_NAME.get();
    }

    public static void setView(View view) {
        VIEW.set(view);
    }

    public static View getView() {
        return VIEW.get();
    }

    public static ModelAndView build() {
        Map<String, Object> otherModel;
        View view;
        ModelAndView modelAndView = new ModelAndView();
        AbstractResponseFormat abstractResponseFormat = (AbstractResponseFormat)BeanUtil.getBean(AbstractResponseFormat.class);
        if (abstractResponseFormat != null) {
            modelAndView = abstractResponseFormat.buildResponse(AgileReturn.getHead(), AgileReturn.getBody());
        } else {
            if (AgileReturn.getHead() != null) {
                modelAndView.addObject("head", (Object)AgileReturn.getHead());
                modelAndView.setStatus(AgileReturn.getHead().getStatus());
            }
            if (AgileReturn.getBody() != null) {
                modelAndView.addAllObjects(AgileReturn.getBody());
            } else {
                modelAndView.addObject("result", AgileReturn.getBody());
            }
        }
        String viewName = AgileReturn.getViewName();
        if (viewName != null) {
            modelAndView.setViewName(viewName);
        }
        if ((view = AgileReturn.getView()) != null) {
            modelAndView.setView(view);
        }
        if ((otherModel = OTHER.get()) != null) {
            modelAndView.addAllObjects(otherModel);
        }
        return modelAndView;
    }

    public static void clear() {
        HEAD.remove();
        OTHER.remove();
        BODY.remove();
        VIEW_NAME.remove();
        VIEW.remove();
    }
}

