/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mybatis.page;

import cloud.agileframework.mybatis.page.MybatisPage;
import cloud.agileframework.mybatis.page.PageExecutor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class MybatisInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = this.getActuralHandlerObject(invocation);
        MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
        String sql = statementHandler.getBoundSql().getSql();
        BoundSql boundSql = statementHandler.getBoundSql();
        Object paramObject = boundSql.getParameterObject();
        MybatisPage mybatisPage = PageExecutor.getPageRequest(paramObject);
        if (mybatisPage == null || !this.checkIsSelectFalg(sql)) {
            return invocation.proceed();
        }
        return this.updateSql2Limit(invocation, metaStatementHandler, mybatisPage.getPageNum(), mybatisPage.getPageSize());
    }

    private StatementHandler getActuralHandlerObject(Invocation invocation) {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
        Object object = null;
        while (true) {
            String h = "h";
            if (!metaStatementHandler.hasGetter("h")) break;
            object = metaStatementHandler.getValue("h");
            metaStatementHandler = SystemMetaObject.forObject((Object)object);
        }
        if (object == null) {
            return statementHandler;
        }
        return (StatementHandler)object;
    }

    private boolean checkIsSelectFalg(String sql) {
        String trimSql = sql.trim();
        int index = trimSql.toLowerCase().indexOf("select");
        return index == 0;
    }

    private Object updateSql2Limit(Invocation invocation, MetaObject metaStatementHandler, int page, int pageSize) throws InvocationTargetException, IllegalAccessException, SQLException {
        MybatisInterceptor.validatePageInfo(page, pageSize);
        String sql = (String)metaStatementHandler.getValue("delegate.boundSql.sql");
        String limitSql = "select * from (" + sql + ") $_paging_table limit ?,?";
        metaStatementHandler.setValue("delegate.boundSql.sql", (Object)limitSql);
        PreparedStatement ps = (PreparedStatement)invocation.proceed();
        int count = ps.getParameterMetaData().getParameterCount();
        ps.setInt(count - 1, (page - 1) * pageSize);
        ps.setInt(count, pageSize);
        return ps;
    }

    public static void validatePageInfo(int page, int size) throws IllegalArgumentException {
        if (size < 1) {
            throw new IllegalArgumentException("\u6bcf\u9875\u663e\u793a\u6761\u6570\u6700\u5c11\u4e3a\u6570\u5b57 1");
        }
        if (page < 1) {
            throw new IllegalArgumentException("\u6700\u5c0f\u9875\u4e3a\u6570\u5b57 1");
        }
    }

    public Object plugin(Object o) {
        if (Executor.class.isAssignableFrom(o.getClass())) {
            PageExecutor executor = new PageExecutor((Executor)o);
            return Plugin.wrap((Object)executor, (Interceptor)this);
        }
        if (o instanceof StatementHandler) {
            return Plugin.wrap((Object)o, (Interceptor)this);
        }
        return o;
    }

    public void setProperties(Properties properties) {
    }
}

