/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mybatis.config;

import cloud.agileframework.mybatis.page.CustomConfiguration;
import cloud.agileframework.mybatis.page.MybatisInterceptor;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(basePackages={"cloud.agileframework"}, annotationClass=Mapper.class)
@ConditionalOnClass(value={SqlSessionFactory.class, MapperScannerConfigurer.class, DataSource.class})
public class MyBatisAutoConfiguration {
    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        CustomConfiguration configuration = new CustomConfiguration();
        configuration.setCallSettersOnNulls(true);
        sessionFactory.setConfiguration((org.apache.ibatis.session.Configuration)configuration);
        sessionFactory.setPlugins(new Interceptor[]{new MybatisInterceptor()});
        return sessionFactory.getObject();
    }
}

