/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mybatis.page;

import cloud.agileframework.mybatis.page.MybatisInterceptor;
import cloud.agileframework.mybatis.page.MybatisPage;
import cloud.agileframework.mybatis.page.Page;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class PageExecutor
implements Executor {
    private Executor executor;

    PageExecutor(Executor executor) {
        this.executor = executor;
    }

    public static MybatisPage getPageRequest(Object paramObject) {
        MybatisPage mybatisPage = null;
        if (paramObject instanceof Map) {
            Map params = (Map)paramObject;
            for (Object value : params.values()) {
                if (!(value instanceof MybatisPage)) continue;
                mybatisPage = (MybatisPage)value;
            }
        } else if (paramObject instanceof MybatisPage) {
            mybatisPage = (MybatisPage)paramObject;
        }
        if (mybatisPage != null) {
            MybatisInterceptor.validatePageInfo(mybatisPage.getPageNum(), mybatisPage.getPageSize());
        }
        return mybatisPage;
    }

    public int update(MappedStatement ms, Object parameter) throws SQLException {
        return this.executor.update(ms, parameter);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, CacheKey cacheKey, BoundSql boundSql) throws SQLException {
        RowBounds rb = new RowBounds(rowBounds.getOffset(), rowBounds.getLimit());
        List rows = this.executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        return this.pageResolver(rows, ms, parameter, rb);
    }

    private <E> List<E> pageResolver(List<E> rows, MappedStatement ms, Object parameter, RowBounds rowBounds) {
        MybatisPage pageRequest = PageExecutor.getPageRequest(parameter);
        if (pageRequest != null) {
            long count = this.getCount(ms, parameter);
            return new Page<E>(rows, pageRequest, count);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount(MappedStatement ms, Object parameter) {
        int result = 0;
        BoundSql bsql = ms.getBoundSql(parameter);
        String sql = bsql.getSql();
        String countSql = this.getCountSql(sql);
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            connection = ms.getConfiguration().getEnvironment().getDataSource().getConnection();
            stmt = connection.prepareStatement(countSql);
            this.setParameters((PreparedStatement)stmt, ms, bsql, parameter);
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            Configuration configuration = mappedStatement.getConfiguration();
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            for (int i = 0; i < parameterMappings.size(); ++i) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                Object value = parameterObject == null ? null : (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass()) ? parameterObject : (boundSql.hasAdditionalParameter(propertyName) ? boundSql.getAdditionalParameter(propertyName) : (metaObject == null ? null : metaObject.getValue(propertyName))));
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                if (typeHandler == null) {
                    throw new ExecutorException("There was no TypeHandler found for parameter " + propertyName + " of statement " + mappedStatement.getId());
                }
                typeHandler.setParameter(ps, i + 1, value, parameterMapping.getJdbcType());
            }
        }
    }

    private String getCountSql(String sql) {
        return String.format("select count(1) from (%s) _select_table", sql);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        BoundSql boundSql = ms.getBoundSql(parameter);
        return this.query(ms, parameter, rowBounds, resultHandler, this.executor.createCacheKey(ms, parameter, rowBounds, boundSql), boundSql);
    }

    public <E> Cursor<E> queryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds) throws SQLException {
        return this.executor.queryCursor(ms, parameter, rowBounds);
    }

    public List<BatchResult> flushStatements() throws SQLException {
        return this.executor.flushStatements();
    }

    public void commit(boolean required) throws SQLException {
        this.executor.commit(required);
    }

    public void rollback(boolean required) throws SQLException {
        this.executor.rollback(required);
    }

    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        return this.executor.createCacheKey(ms, parameterObject, rowBounds, boundSql);
    }

    public boolean isCached(MappedStatement ms, CacheKey key) {
        return this.executor.isCached(ms, key);
    }

    public void clearLocalCache() {
        this.executor.clearLocalCache();
    }

    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key, Class<?> targetType) {
        this.executor.deferLoad(ms, resultObject, property, key, targetType);
    }

    public Transaction getTransaction() {
        return this.executor.getTransaction();
    }

    public void close(boolean forceRollback) {
        this.executor.close(forceRollback);
    }

    public boolean isClosed() {
        return this.executor.isClosed();
    }

    public void setExecutorWrapper(Executor executor) {
        executor.setExecutorWrapper(executor);
    }
}

