/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.db;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBaseUtil {
    private static final Logger logger = LoggerFactory.getLogger(DataBaseUtil.class);
    private static Connection conn;

    private static ResultSet getResultSet(PATTERN type, String url, String username, String password, String pattern) {
        DBInfo dbInfo = DataBaseUtil.parseDBUrl(url);
        if (dbInfo == null) {
            throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b");
        }
        try {
            conn = DataBaseUtil.getConnection(url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pattern = pattern == null ? "%" : pattern;
        ResultSet rs = null;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            String schemaPattern = null;
            String catalog = null;
            switch (type) {
                case TABLE: {
                    String[] types = new String[]{"TABLE", "VIEW"};
                    if (dbInfo.type == DB.ORACLE) {
                        schemaPattern = username;
                        if (null != schemaPattern) {
                            schemaPattern = schemaPattern.toUpperCase();
                        }
                        rs = meta.getTables(null, schemaPattern, pattern, types);
                        break;
                    }
                    if (dbInfo.type == DB.MYSQL) {
                        schemaPattern = dbInfo.getName();
                        rs = meta.getTables(schemaPattern, schemaPattern, pattern, types);
                        break;
                    }
                    if (dbInfo.type == DB.DB2) {
                        schemaPattern = dbInfo.getName();
                        rs = meta.getTables(null, schemaPattern, pattern, types);
                        break;
                    }
                    rs = meta.getTables(null, null, pattern, types);
                    break;
                }
                case COLUMN: {
                    pattern = pattern.toUpperCase();
                    String columnNamePattern = null;
                    if (DB.ORACLE == dbInfo.type) {
                        schemaPattern = username;
                        if (null != schemaPattern) {
                            schemaPattern = schemaPattern.toUpperCase();
                        }
                    } else if (DB.MYSQL == dbInfo.type) {
                        catalog = dbInfo.getName();
                        schemaPattern = dbInfo.getName();
                    }
                    rs = meta.getColumns(catalog, schemaPattern, pattern, columnNamePattern);
                    break;
                }
                case PRIMARY_KEY: {
                    pattern = pattern.toUpperCase();
                    if (DB.ORACLE == dbInfo.type && null != (schemaPattern = username)) {
                        schemaPattern = schemaPattern.toUpperCase();
                    }
                    rs = meta.getPrimaryKeys(null, schemaPattern, pattern);
                    break;
                }
                case FK_EXPORT: {
                    pattern = pattern.toUpperCase();
                    if (DB.ORACLE == dbInfo.type && null != (schemaPattern = username)) {
                        schemaPattern = schemaPattern.toUpperCase();
                    }
                    rs = meta.getExportedKeys(null, schemaPattern, pattern);
                    break;
                }
                case FK_IMPORT: {
                    pattern = pattern.toUpperCase();
                    if (DB.ORACLE == dbInfo.type && null != (schemaPattern = username)) {
                        schemaPattern = schemaPattern.toUpperCase();
                    }
                    rs = meta.getImportedKeys(null, schemaPattern, pattern);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static List<Map<String, Object>> listTables(String url, String username, String password, String tableName) {
        if (tableName.contains(",")) {
            String[] tables = tableName.replaceAll("((?![%-])\\W)+", ",").split(",");
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (String table : tables) {
                list.addAll(DataBaseUtil.getDBInfo(PATTERN.TABLE, url, username, password, table));
            }
            return list;
        }
        return DataBaseUtil.getDBInfo(PATTERN.TABLE, url, username, password, tableName.trim());
    }

    public static List<Map<String, Object>> listColumns(String url, String username, String password, String tableName) {
        List<Map<String, Object>> list = DataBaseUtil.getDBInfo(PATTERN.COLUMN, url, username, password, tableName);
        List<Map<String, Object>> keyList = DataBaseUtil.listPrimayKeys(url, username, password, tableName);
        for (Map<String, Object> keyColumn : keyList) {
            for (Map<String, Object> column : list) {
                boolean isPrimaryKey = false;
                if (keyColumn.get("COLUMN_NAME").toString().equals(column.get("COLUMN_NAME").toString())) {
                    isPrimaryKey = true;
                }
                column.put("IS_PRIMARY_KEY", isPrimaryKey);
            }
        }
        return list;
    }

    public static List<Map<String, Object>> listPrimayKeys(String url, String username, String password, String tableName) {
        return DataBaseUtil.getDBInfo(PATTERN.PRIMARY_KEY, url, username, password, tableName);
    }

    public static List<Map<String, Object>> listFKeys(String url, String username, String password, String tableName) {
        return DataBaseUtil.getDBInfo(PATTERN.FK_EXPORT, url, username, password, tableName);
    }

    public static List<Map<String, Object>> listFImportKeys(String url, String username, String password, String tableName) {
        return DataBaseUtil.getDBInfo(PATTERN.FK_IMPORT, url, username, password, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getDBInfo(PATTERN pattern, String url, String username, String password, String tableName) {
        List<Map<String, Object>> list = null;
        ResultSet rs = null;
        try {
            rs = DataBaseUtil.getResultSet(pattern, url, username, password, tableName);
            list = DataBaseUtil.parseResultSetToMapList(rs);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DataBaseUtil.close(rs);
                DataBaseUtil.close(conn);
                throw throwable;
            }
            DataBaseUtil.close(rs);
            DataBaseUtil.close(conn);
        }
        DataBaseUtil.close(rs);
        DataBaseUtil.close(conn);
        return list;
    }

    public static DBInfo parseDBUrl(String url) {
        DB db = Stream.of(DB.values()).filter(node -> PatternUtil.matches((String)((DB)node).parsingUrlRegx, (String)url)).findFirst().orElse(null);
        if (db == null) {
            return null;
        }
        Map map = PatternUtil.getGroups((String)db.parsingUrlRegx, (String)url.replace(" ", ""));
        if (map == null) {
            return null;
        }
        DBInfo dbInfo = (DBInfo)ObjectUtil.to((Object)map, (TypeReference)new TypeReference<DBInfo>(){});
        dbInfo.setType(db);
        return dbInfo;
    }

    public static Connection getConnection(String url, String username, String password) throws SQLException {
        Properties info = new Properties();
        info.put("user", username);
        info.put("password", password);
        info.put("remarksReporting", "true");
        info.put("useInformationSchema", "true");
        return DriverManager.getConnection(url, info);
    }

    private static List<Map<String, Object>> parseResultSetToMapList(ResultSet rs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (null == rs) {
            return result;
        }
        try {
            while (rs.next()) {
                Map<String, Object> map = DataBaseUtil.parseResultSetToMap(rs);
                result.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Map<String, Object> parseResultSetToMap(ResultSet rs) {
        if (null == rs) {
            return null;
        }
        int length = 16;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int colNum = meta.getColumnCount();
            for (int i = 1; i <= colNum; ++i) {
                String name = meta.getColumnLabel(i);
                Object value = rs.getObject(i);
                map.put(name, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void demoResultSetMetaData(ResultSetMetaData data) throws SQLException {
        for (int i = 1; i <= data.getColumnCount(); ++i) {
            int columnCount = data.getColumnCount();
            String columnName = data.getColumnName(i);
            int columnType = data.getColumnType(i);
            String columnTypeName = data.getColumnTypeName(i);
            String catalogName = data.getCatalogName(i);
            String columnClassName = data.getColumnClassName(i);
            int columnDisplaySize = data.getColumnDisplaySize(i);
            String columnLabel = data.getColumnLabel(i);
            String schemaName = data.getSchemaName(i);
            int precision = data.getPrecision(i);
            int scale = data.getScale(i);
            String tableName = data.getTableName(i);
            boolean isAutoInctement = data.isAutoIncrement(i);
            boolean isCurrency = data.isCurrency(i);
            int isNullable = data.isNullable(i);
            boolean isReadOnly = data.isReadOnly(i);
            boolean isSearchable = data.isSearchable(i);
            logger.info(columnCount + "");
            logger.info("\u83b7\u5f97\u5217" + i + "\u7684\u5b57\u6bb5\u540d\u79f0:" + columnName);
            logger.info("\u83b7\u5f97\u5217" + i + "\u7684\u7c7b\u578b,\u8fd4\u56deSqlType\u4e2d\u7684\u7f16\u53f7:" + columnType);
            logger.info("\u83b7\u5f97\u5217" + i + "\u7684\u6570\u636e\u7c7b\u578b\u540d:" + columnTypeName);
            logger.info("\u83b7\u5f97\u5217" + i + "\u6240\u5728\u7684Catalog\u540d\u5b57:" + catalogName);
            logger.info("\u83b7\u5f97\u5217" + i + "\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\u7684\u7c7b:" + columnClassName);
            logger.info("\u83b7\u5f97\u5217" + i + "\u5728\u6570\u636e\u5e93\u4e2d\u7c7b\u578b\u7684\u6700\u5927\u5b57\u7b26\u4e2a\u6570:" + columnDisplaySize);
            logger.info("\u83b7\u5f97\u5217" + i + "\u7684\u9ed8\u8ba4\u7684\u5217\u7684\u6807\u9898:" + columnLabel);
            logger.info("\u83b7\u5f97\u5217" + i + "\u7684\u6a21\u5f0f:" + schemaName);
            logger.info("\u83b7\u5f97\u5217" + i + "\u7c7b\u578b\u7684\u7cbe\u786e\u5ea6(\u7c7b\u578b\u7684\u957f\u5ea6):" + precision);
            logger.info("\u83b7\u5f97\u5217" + i + "\u5c0f\u6570\u70b9\u540e\u7684\u4f4d\u6570:" + scale);
            logger.info("\u83b7\u5f97\u5217" + i + "\u5bf9\u5e94\u7684\u8868\u540d:" + tableName);
            logger.info("\u83b7\u5f97\u5217" + i + "\u662f\u5426\u81ea\u52a8\u9012\u589e:" + isAutoInctement);
            logger.info("\u83b7\u5f97\u5217" + i + "\u5728\u6570\u636e\u5e93\u4e2d\u662f\u5426\u4e3a\u8d27\u5e01\u578b:" + isCurrency);
            logger.info("\u83b7\u5f97\u5217" + i + "\u662f\u5426\u4e3a\u7a7a:" + isNullable);
            logger.info("\u83b7\u5f97\u5217" + i + "\u662f\u5426\u4e3a\u53ea\u8bfb:" + isReadOnly);
            logger.info("\u83b7\u5f97\u5217" + i + "\u80fd\u5426\u51fa\u73b0\u5728where\u4e2d:" + isSearchable);
        }
    }

    public static enum PATTERN {
        TABLE,
        COLUMN,
        PRIMARY_KEY,
        FK_EXPORT,
        FK_IMPORT;

    }

    public static enum DB {
        ORACLE("jdbc:oracle:thin:@(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+):(?<name>[\\w-]+)"),
        MYSQL("jdbc:mysql://(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+)/(?<name>[\\w-]+)(?<param>[\\w\\W]*)"),
        SQL_SERVER("jdbc:jtds:sqlserver://(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+)/(?<name>[\\w-]+)(?<param>[\\w\\W=]+)"),
        SQL_SERVER2005("jdbc:sqlserver://(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+);DatabaseName=(?<name>[\\w-]+)"),
        DB2("jdbc:db2://(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+)/(?<name>[\\w-]+)"),
        INFORMIX("jdbc:informix-sqli://(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+)/(?<name>[\\w-]+)"),
        SYBASE("jdbc:sybase:Tds:(?<ip>[0-9.a-zA-Z-_]+):(?<port>[0-9]+)/(?<name>[\\w-]+)"),
        OTHER(null);

        private final String parsingUrlRegx;

        private DB(String parsingUrlRegx) {
            this.parsingUrlRegx = parsingUrlRegx;
        }
    }

    public static class DBInfo {
        private DB type;
        private String ip;
        private String port;
        private String name;

        public DB getType() {
            return this.type;
        }

        public void setType(DB type) {
            this.type = type;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

