/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.db;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.sql.SqlUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.util.JdbcUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    private static final Logger log = LoggerFactory.getLogger(SessionUtil.class);

    public static <T> List<T> query(Connection connection, String sql, Class<T> clazz, Object param) throws SQLException {
        List<Map<String, Object>> temp = SessionUtil.query(connection, sql, param);
        return SessionUtil.toJavaObjectList(clazz, temp);
    }

    public static <T> List<T> query(Connection connection, String sql, Class<T> clazz) throws SQLException {
        List<Map<String, Object>> temp = SessionUtil.query(connection, sql, Maps.newHashMap());
        return SessionUtil.toJavaObjectList(clazz, temp);
    }

    public static List<Map<String, Object>> query(Connection connection, String sql, Object param) throws SQLException {
        String newSql = SessionUtil.parseSql(connection, sql, param);
        return SessionUtil.execute(connection, newSql);
    }

    public static List<Map<String, Object>> query(Connection connection, String sql) throws SQLException {
        String newSql = SessionUtil.parseSql(connection, sql, null);
        return SessionUtil.execute(connection, newSql);
    }

    public static <T> List<T> limit(Connection connection, String sql, Class<T> clazz, Object param, int offset, int count) throws SQLException {
        List<Map<String, Object>> list = SessionUtil.execute(connection, SessionUtil.parseLimitSql(connection, sql, param, offset, count));
        return SessionUtil.toJavaObjectList(clazz, list);
    }

    public static <T> List<T> limit(Connection connection, String sql, Class<T> clazz, int offset, int count) throws SQLException {
        List<Map<String, Object>> list = SessionUtil.execute(connection, SessionUtil.parseLimitSql(connection, sql, null, offset, count));
        return SessionUtil.toJavaObjectList(clazz, list);
    }

    public static List<Map<String, Object>> limit(Connection connection, String sql, Object param, int offset, int count) throws SQLException {
        return SessionUtil.execute(connection, SessionUtil.parseLimitSql(connection, sql, param, offset, count));
    }

    public static List<Map<String, Object>> limit(Connection connection, String sql, int offset, int count) throws SQLException {
        return SessionUtil.execute(connection, SessionUtil.parseLimitSql(connection, sql, null, offset, count));
    }

    public static long count(Connection connection, String sql, Object param) throws SQLException {
        List<Map<String, Object>> list = SessionUtil.execute(connection, SessionUtil.parseCountSql(connection, sql, param));
        if (list.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(list.stream().flatMap(a -> a.values().stream()).findFirst().orElse("0").toString());
    }

    public static long count(Connection connection, String sql) throws SQLException {
        List<Map<String, Object>> list = SessionUtil.execute(connection, SessionUtil.parseCountSql(connection, sql, null));
        if (list.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(list.stream().flatMap(a -> a.values().stream()).findFirst().orElse("0").toString());
    }

    public static <T> List<T> toJavaObjectList(Class<T> clazz, List<Map<String, Object>> data) {
        if (data.isEmpty()) {
            return Lists.newArrayList();
        }
        if (ClassUtil.isWrapOrPrimitive(clazz) || Date.class.isAssignableFrom(clazz) || String.class == clazz) {
            return data.stream().flatMap(n -> n.values().stream()).map(a -> ObjectUtil.to((Object)a, (TypeReference)new TypeReference((Type)clazz))).collect(Collectors.toList());
        }
        return data.stream().map(a -> ObjectUtil.to((Object)a, (TypeReference)new TypeReference((Type)clazz))).collect(Collectors.toList());
    }

    private static String parseSql(Connection connection, String sql, Object param) throws SQLException {
        DbType dbType = JdbcUtils.getDbTypeRaw((String)connection.getMetaData().getURL(), null);
        return SqlUtil.parserSQLByType(dbType, sql, param);
    }

    private static String parseLimitSql(Connection connection, String sql, Object param, int offset, int count) throws SQLException {
        DbType dbType = JdbcUtils.getDbTypeRaw((String)connection.getMetaData().getURL(), null);
        return SqlUtil.parserLimitSQLByType(dbType, sql, param, offset, count);
    }

    private static String parseCountSql(Connection connection, String sql, Object param) throws SQLException {
        DbType dbType = JdbcUtils.getDbTypeRaw((String)connection.getMetaData().getURL(), null);
        return SqlUtil.parserCountSQLByType(dbType, sql, param);
    }

    public static List<Map<String, Object>> execute(Connection connection, String sql) {
        ArrayList list = Lists.newArrayList();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ArrayList columns = Lists.newArrayList();
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                columns.add(metaData.getColumnName(i));
            }
            while (resultSet.next()) {
                HashMap map = Maps.newHashMap();
                columns.forEach(column -> {
                    try {
                        map.put(column, resultSet.getString((String)column));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });
                list.add(map);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private static <T> T preparedParseSql(Connection connection, String sql, Object param, Function<PreparedStatement, T> function) throws SQLException {
        HashMap params = Maps.newHashMap();
        try (PreparedStatement statement = connection.prepareStatement(SqlUtil.parserSQLByType(JdbcUtils.getDbTypeRaw((String)connection.getMetaData().getURL(), null), sql, param, params));){
            for (Map.Entry e : params.entrySet()) {
                statement.setObject(Integer.parseInt((String)e.getKey()), e.getValue());
            }
            Iterator iterator = function.apply(statement);
            return (T)iterator;
        }
    }

    public static int update(Connection connection, String sql) throws SQLException {
        return SessionUtil.update(connection, sql, Maps.newHashMap());
    }

    public static int update(Connection connection, String sql, Object param) throws SQLException {
        Integer count = SessionUtil.preparedParseSql(connection, sql, param, a -> {
            if (a == null) {
                return 0;
            }
            try {
                return a.executeUpdate();
            }
            catch (SQLException throwable) {
                throw new RuntimeException(throwable);
            }
        });
        return count == null ? 0 : count;
    }

    public static void batchUpdate(Connection connection, List<String> sql) throws SQLException {
        try (Statement statement = connection.createStatement();){
            for (String s : sql) {
                statement.addBatch(s);
            }
            statement.executeBatch();
        }
    }

    public static void batchUpdate(Connection connection, String sql, List<Map<String, Object>> params) throws SQLException {
        HashMap batches = Maps.newHashMap();
        HashMap temp = Maps.newHashMap();
        for (Map<String, Object> map : params) {
            String prepareSql = SqlUtil.parserSQLByType(JdbcUtils.getDbTypeRaw((String)connection.getMetaData().getURL(), null), sql, map, temp);
            List values = (List)batches.get(prepareSql);
            if (values == null) {
                values = Lists.newArrayList();
            }
            values.add(Maps.newHashMap((Map)temp));
            batches.put(prepareSql, values);
            temp.clear();
        }
        for (Map.Entry entry : batches.entrySet()) {
            PreparedStatement statement = connection.prepareStatement((String)entry.getKey());
            Throwable throwable = null;
            try {
                for (Map param : (List)entry.getValue()) {
                    for (Map.Entry e : param.entrySet()) {
                        statement.setObject(Integer.parseInt((String)e.getKey()), e.getValue());
                    }
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }
}

