/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.sql;

import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.sql.SqlUtil;
import cloud.agileframework.sql.WhereIn;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.ParserException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Param {
    public static final String SQL_ILLEGAL = "\\b(sp_|xp_|execute|like|create|group|order|by|having|where|from|union|and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or|ifnull|0[xX][\\da-fA-F]+)\\b|([*;+'%])";
    public static final int INITIAL_CAPACITY = 16;
    private static final ThreadLocal<Map<String, Object>> THREAD_LOCAL = new ThreadLocal();
    public static final String PARAM_START = "@_START_";
    public static final String PARAM_INDEX = "_INDEX";
    public static final String PARAM_END = "_END_";
    public static final String PARAM_SPLIT = "_SPLIT_";
    public static final String NOT_FOUND_PARAM = "@NOT_FOUND_PARAM_";
    public static final String REPLACE_NULL_CONDITION = " 1=1 ";
    private final String placeHolder;

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public Param(String key, Object value) {
        this.placeHolder = PARAM_START + key.replace(".", PARAM_SPLIT) + PARAM_END;
        THREAD_LOCAL.get().put(this.placeHolder, value);
    }

    public static void isIllegal(String sql) {
        Matcher matcher = Pattern.compile(SQL_ILLEGAL).matcher(sql.toLowerCase());
        if (matcher.find()) {
            throw new ParserException("SQL \u6ce8\u5165\u98ce\u9669");
        }
    }

    public static Object parsingParam(Object params) {
        THREAD_LOCAL.remove();
        THREAD_LOCAL.set(new HashMap(16));
        if (params == null) {
            return null;
        }
        return JSONUtil.toMapOrList((Object)params);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        if (obj instanceof CharSequence) {
            int strLen = ((CharSequence)obj).length();
            if (strLen == 0) {
                return true;
            }
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(((CharSequence)obj).charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            Set set = ((Collection)obj).stream().filter(node -> !StringUtil.isEmpty((CharSequence)String.valueOf(node))).collect(Collectors.toSet());
            return ((Collection)set).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static String parsingSqlString(String sql, Object params) {
        sql = StringUtil.parsingPlaceholder((String)"${", (String)"}", (String)":", (String)sql, (Object)params, (String)NOT_FOUND_PARAM);
        return Param.parsingPlaceholder("#{", "}", ":", sql, params, NOT_FOUND_PARAM);
    }

    private static String parsingPlaceholder(String openToken, String closeToken, String equalToken, String text, Object args, String replaceNull) {
        if (args == null) {
            if (replaceNull != null) {
                args = new HashMap(0);
            } else {
                return text;
            }
        }
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String value;
                    Object o;
                    String key = expression.toString();
                    String[] keyObj = key.split(equalToken);
                    String replaceKey = null;
                    if (keyObj.length > 0) {
                        o = JSONUtil.pathGet((String)keyObj[0].trim(), args);
                        if (o != null) {
                            replaceKey = keyObj[0].trim();
                        }
                    } else {
                        o = JSONUtil.pathGet((String)key.trim(), args);
                        if (o != null) {
                            replaceKey = key.trim();
                        }
                    }
                    if (o == null || Param.isEmpty(o)) {
                        value = key.contains(equalToken) ? keyObj[1].trim() : (replaceNull != null ? replaceNull : openToken + key + closeToken);
                    } else {
                        Param param = new Param(replaceKey, o);
                        value = param.getPlaceHolder();
                    }
                    builder.append(value);
                    offset = end + closeToken.length();
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static void parsingPlaceHolder(String sql) {
        Set set = THREAD_LOCAL.get().entrySet().stream().filter(param -> sql.contains((CharSequence)param.getKey())).collect(Collectors.toSet());
        for (Map.Entry param2 : set) {
            SqlUtil.setQueryParamThreadLocal((String)param2.getKey(), param2.getValue());
        }
    }

    private static void parsingPlaceHolder(String sql, Consumer<Map.Entry<String, Object>> consumer) {
        Set set = THREAD_LOCAL.get().entrySet().stream().filter(param -> sql.contains((CharSequence)param.getKey())).collect(Collectors.toSet());
        for (Map.Entry param2 : set) {
            if (consumer == null) continue;
            consumer.accept(param2);
        }
    }

    public static void parsingSQLSelectItem(SQLSelectQueryBlock sqlSelectQueryBlock) {
        if (sqlSelectQueryBlock == null) {
            return;
        }
        List sqlSelectItems = sqlSelectQueryBlock.getSelectList();
        sqlSelectItems.removeIf(Param::unprocessed);
    }

    public static void parsingSQLUpdateStatement(SQLUpdateStatement sqlUpdateStatement) {
        if (sqlUpdateStatement == null) {
            return;
        }
        List items = sqlUpdateStatement.getItems();
        items.removeIf(Param::unprocessed);
    }

    public static void parsingSQLInsertStatement(SQLInsertStatement statement) {
        if (statement == null) {
            return;
        }
        List columns = statement.getColumns();
        List values = statement.getValues().getValues();
        if (columns.size() != values.size()) {
            throw new ParserException("\u63d2\u5165\u7684\u5b57\u6bb5\u6570\u91cf\u4e0e\u503c\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        Iterator it = columns.iterator();
        while (it.hasNext()) {
            SQLExpr column = (SQLExpr)it.next();
            SQLExpr valueSQLExpr = (SQLExpr)values.get(columns.indexOf(column));
            if (!Param.unprocessed((SQLObject)column) && !Param.unprocessed((SQLObject)valueSQLExpr)) continue;
            it.remove();
            values.remove(valueSQLExpr);
        }
    }

    public static void parsingSQLInListExpr(SQLInListExpr sqlExpr) {
        if (sqlExpr == null) {
            return;
        }
        List targetList = sqlExpr.getTargetList();
        targetList.removeIf(Param::unprocessed);
        if (targetList.isEmpty()) {
            SQLUtils.replaceInParent((SQLExpr)sqlExpr, (SQLExpr)SQLUtils.toSQLExpr((String)REPLACE_NULL_CONDITION, (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()));
            return;
        }
        Param.parsingPlaceHolder(SQLUtils.toSQLString((SQLObject)sqlExpr, (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()), value -> {
            String key = (String)value.getKey();
            Object vs = value.getValue();
            if (Collection.class.isAssignableFrom(vs.getClass()) || vs.getClass().isArray()) {
                ArrayList<Object> list;
                if (vs.getClass().isArray()) {
                    ArrayList<Object> collection = new ArrayList<Object>();
                    int length = Array.getLength(vs);
                    for (int i = 0; i < length; ++i) {
                        Object v = Array.get(vs, i);
                        collection.add(v);
                    }
                    list = collection;
                } else {
                    list = new ArrayList<Object>((Collection)vs);
                }
                for (int i = 0; i < list.size(); ++i) {
                    String ck = key + i + PARAM_INDEX;
                    Object cv = list.get(i);
                    SqlUtil.setQueryParamThreadLocal(ck, cv);
                }
                SqlUtil.setQueryParamThreadLocal(key, new WhereIn(key, list));
            }
        });
    }

    public static void parsingSQLBinaryOpExpr(SQLBinaryOpExpr sqlExpr) {
        if (sqlExpr == null) {
            return;
        }
        if (Param.unprocessed((SQLObject)sqlExpr)) {
            SQLUtils.replaceInParent((SQLExpr)sqlExpr, (SQLExpr)SQLUtils.toSQLExpr((String)REPLACE_NULL_CONDITION, (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()));
        }
    }

    public static void parsingSQLOrderBy(SQLOrderBy sqlExpr) {
        if (sqlExpr == null) {
            return;
        }
        List orders = sqlExpr.getItems();
        orders.removeIf(Param::unprocessed);
    }

    public static void parsingSQLSelectGroupByClause(SQLSelectGroupByClause sqlExpr) {
        SQLExpr having;
        if (sqlExpr == null) {
            return;
        }
        List items = sqlExpr.getItems();
        if (!ObjectUtil.isEmpty((Object)items)) {
            items.removeIf(Param::unprocessed);
        }
        if ((having = sqlExpr.getHaving()) != null) {
            SqlUtil.parserSQLObject(having);
            SQLExpr newHaving = SqlUtil.parsingWhereConstant(having);
            sqlExpr.setHaving(newHaving);
        }
    }

    public static boolean unprocessed(SQLObject sql) {
        return SQLUtils.toSQLString((SQLObject)sql, (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()).contains(NOT_FOUND_PARAM);
    }

    public static void parsingSQLBetweenExpr(SQLBetweenExpr part) {
        if (Param.unprocessed((SQLObject)part)) {
            SQLUtils.replaceInParent((SQLExpr)part, (SQLExpr)SQLUtils.toSQLExpr((String)REPLACE_NULL_CONDITION, (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()));
        }
    }

    public static void parsingMethodInvoke(SQLMethodInvokeExpr methodInvokeExpr) {
        if (Param.unprocessed((SQLObject)methodInvokeExpr)) {
            SQLObject selectQuery;
            SQLObject parent = methodInvokeExpr.getParent();
            if (parent instanceof SQLBinaryOpExpr) {
                ((SQLBinaryOpExpr)parent).setRight(SQLUtils.toSQLExpr((String)"1", (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()));
                ((SQLBinaryOpExpr)parent).setLeft(SQLUtils.toSQLExpr((String)"1", (DbType)SqlUtil.DB_TYPE_THREAD_LOCAL.get()));
                ((SQLBinaryOpExpr)parent).setOperator(SQLBinaryOperator.Equality);
            } else if (parent instanceof SQLInListExpr) {
                ((SQLInListExpr)parent).getTargetList().remove(methodInvokeExpr);
            } else if (parent instanceof SQLUpdateSetItem) {
                SQLObject updateStatement = parent.getParent();
                if (updateStatement instanceof SQLUpdateStatement) {
                    ((SQLUpdateStatement)updateStatement).getItems().remove(parent);
                }
            } else if (parent instanceof SQLSelectItem && (selectQuery = parent.getParent()) instanceof SQLSelectQueryBlock) {
                ((SQLSelectQueryBlock)selectQuery).getSelectList().remove(parent);
            }
        }
    }
}

