/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.sql;

import cloud.agileframework.common.util.template.VelocityUtil;
import cloud.agileframework.sql.Param;
import cloud.agileframework.sql.WhereIn;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.PagerUtils;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateTimeExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.util.JdbcConstants;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    public static final String CONSTANT_CONDITION_REGEX = "((OR|AND|LIKE)[\\s]+1[\\s]*=[\\s]*1)|(1[\\s]*=[\\s]*1[\\s]+(OR|AND|LIKE))|(^1[\\s]*=[\\s]*1)";
    public static final String CONSTANT_CONDITION = "1 = 1";
    public static final ThreadLocal<DbType> DB_TYPE_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> QUERY_PARAM_THREAD_LOCAL = new ThreadLocal();
    private static Logger log = LoggerFactory.getLogger(SqlUtil.class);

    public static String parserCountSQLByType(DbType dbType, String sql, Object parameters, Map<String, Object> query) {
        return SqlUtil.parserSQLByType(dbType, sql, parameters, query, (a, b) -> PagerUtils.count((String)b, (DbType)a));
    }

    public static String parserCountSQLByType(DbType dbType, String sql, Object parameters) {
        return SqlUtil.parserSQLByType(dbType, sql, parameters, null, (a, b) -> PagerUtils.count((String)b, (DbType)a));
    }

    public static String parserCountSQLByType(DbType dbType, String sql) {
        return SqlUtil.parserSQLByType(dbType, sql, null, null, (a, b) -> PagerUtils.count((String)b, (DbType)a));
    }

    public static String parserCountSQL(String sql, Object parameters, Map<String, Object> query) {
        return SqlUtil.parserSQLByType(null, sql, parameters, query, (a, b) -> PagerUtils.count((String)b, (DbType)a));
    }

    public static String parserCountSQL(String sql) {
        return SqlUtil.parserSQLByType(null, sql, null, null, (a, b) -> PagerUtils.count((String)b, (DbType)a));
    }

    public static String parserCountSQL(String sql, Object parameters) {
        return SqlUtil.parserSQLByType(null, sql, parameters, null, (a, b) -> PagerUtils.count((String)b, (DbType)a));
    }

    public static String parserSQL(String sql, Object parameters) {
        return SqlUtil.parserSQLByType(null, sql, parameters, null);
    }

    public static String parserSQL(String sql, Object parameters, Map<String, Object> query) {
        return SqlUtil.parserSQLByType(null, sql, parameters, query);
    }

    private static String parserSQL(String sql) {
        return SqlUtil.parserSQLByType(null, sql, null, null);
    }

    public static String parserSQLByType(DbType dbType, String sql, Object parameters) {
        return SqlUtil.parserSQLByType(dbType, sql, parameters, null);
    }

    public static String parserLimitSQLByType(DbType dbType, String sql, Object parameters, int offset, int count) {
        return SqlUtil.parserSQLByType(dbType, sql, parameters, null, (a, b) -> PagerUtils.limit((String)b, (DbType)a, (int)offset, (int)count));
    }

    public static String parserLimitSQLByType(DbType dbType, String sql, int offset, int count, Map<String, Object> query) {
        return SqlUtil.parserSQLByType(dbType, sql, null, query, (a, b) -> PagerUtils.limit((String)b, (DbType)a, (int)offset, (int)count));
    }

    public static String parserLimitSQLByType(DbType dbType, String sql, int offset, int count) {
        return SqlUtil.parserSQLByType(dbType, sql, null, null, (a, b) -> PagerUtils.limit((String)b, (DbType)a, (int)offset, (int)count));
    }

    public static String parserLimitSQLByType(DbType dbType, String sql, Object parameters, int offset, int count, Map<String, Object> query) {
        return SqlUtil.parserSQLByType(dbType, sql, parameters, query, (a, b) -> PagerUtils.limit((String)b, (DbType)a, (int)offset, (int)count));
    }

    public static String parserSQLByType(DbType dbType, String sql, Object parameters, Map<String, Object> query) {
        return SqlUtil.parserSQLByType(dbType, sql, parameters, query, (a, b) -> b);
    }

    public static String parserSQLByType(DbType dbType, String sqlSource, Object parameters, Map<String, Object> query, BiFunction<DbType, String, String> machining) {
        dbType = dbType == null ? DbType.mysql : dbType;
        SqlUtil.setQueryParamThreadLocal(query);
        String sql = sqlSource;
        try {
            sql = VelocityUtil.parse((String)sqlSource, (Object)parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sql = Param.parsingSqlString(sql, Param.parsingParam(parameters));
            Param.parsingPlaceHolder(sql);
            sql = sql.replace("< @", "<  @");
            sql = SqlUtil.parserSQLByType(dbType, sql);
            sql = machining.apply(dbType, sql);
            Map<String, Object> queryParams = QUERY_PARAM_THREAD_LOCAL.get();
            if (queryParams != null) {
                Iterator<Map.Entry<String, Object>> it = queryParams.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Object> e = it.next();
                    String k = e.getKey();
                    Object v = e.getValue();
                    if (!(v instanceof WhereIn)) continue;
                    sql = sql.replace(k, ((WhereIn)v).sql());
                    it.remove();
                }
                if (query != null) {
                    String finalSql = sql;
                    List paramSortedList = queryParams.keySet().stream().sorted(Comparator.comparingInt(finalSql::indexOf)).collect(Collectors.toList());
                    int i = 1;
                    HashMap resolvedQueryParams = Maps.newHashMap();
                    for (String param : paramSortedList) {
                        while (sql.contains(param)) {
                            sql = StringUtils.replaceOnce((String)sql, (String)param, (String)"?");
                            Object v = queryParams.get(param);
                            resolvedQueryParams.put(String.valueOf(i++), v);
                        }
                    }
                    queryParams.clear();
                    queryParams.putAll(resolvedQueryParams);
                } else {
                    for (String param : queryParams.keySet()) {
                        Object value = queryParams.get(param);
                        if (value instanceof Number) {
                            sql = sql.replace(param, SQLUtils.toSQLString((SQLObject)new SQLIntegerExpr((Number)value), (DbType)dbType));
                            continue;
                        }
                        if (value instanceof Boolean) {
                            sql = sql.replace(param, SQLUtils.toSQLString((SQLObject)new SQLBooleanExpr(((Boolean)value).booleanValue()), (DbType)dbType));
                            continue;
                        }
                        if (value instanceof Date) {
                            sql = sql.replace(param, SQLUtils.toSQLString((SQLObject)new SQLDateTimeExpr((Date)value, TimeZone.getDefault())));
                            continue;
                        }
                        if (value == null) {
                            sql = sql.replace(param, SQLUtils.toSQLString((SQLObject)new SQLNullExpr()));
                            continue;
                        }
                        sql = sql.replace(param, SQLUtils.toSQLString((SQLObject)new SQLCharExpr(value.toString()), (DbType)dbType));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("agile-sql parse exception", (Throwable)e);
            throw e;
        }
        finally {
            QUERY_PARAM_THREAD_LOCAL.remove();
        }
        return sql;
    }

    private static String parserSQLByType(DbType dbType, String sql) {
        if (dbType == null) {
            dbType = DB_TYPE_THREAD_LOCAL.get();
            dbType = dbType == null ? JdbcConstants.MYSQL : dbType;
        }
        DB_TYPE_THREAD_LOCAL.set(dbType);
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)dbType);
        SQLStatement statement = parser.parseStatement();
        SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor((DbType)dbType);
        statement.accept((SQLASTVisitor)visitor);
        SqlUtil.parsingPart((SQLObject)statement);
        DB_TYPE_THREAD_LOCAL.remove();
        return SQLUtils.toSQLString((SQLObject)statement, (DbType)dbType, (SQLUtils.FormatOption)new SQLUtils.FormatOption(true, false));
    }

    private static void parserInsert(SQLInsertStatement statement) {
        SqlUtil.parsingTableSource((SQLTableSource)statement.getTableSource());
        Param.parsingSQLInsertStatement(statement);
    }

    private static void parserDelete(SQLDeleteStatement statement) {
        SqlUtil.parsingTableSource(statement.getTableSource());
        SqlUtil.parsingTableSource(statement.getFrom());
        SqlUtil.parsingWhere(statement.getWhere());
    }

    private static void parserUpdate(SQLUpdateStatement statement) {
        Param.parsingSQLUpdateStatement(statement);
        SqlUtil.parsingTableSource(statement.getTableSource());
        SqlUtil.parsingTableSource(statement.getFrom());
        SqlUtil.parsingWhere(statement.getWhere());
        SQLOrderBy order = statement.getOrderBy();
        Param.parsingSQLOrderBy(order);
    }

    private static void parserSelect(SQLSelectStatement statement) {
        SQLSelect sqlSelect = statement.getSelect();
        SqlUtil.parserSQLSelect(sqlSelect);
    }

    private static void parserSQLSelect(SQLSelect sqlSelect) {
        SqlUtil.parserQuery(sqlSelect.getQuery());
    }

    private static void parserQuery(SQLSelectQuery query) {
        if (query instanceof SQLSelectQueryBlock) {
            SQLOrderBy order;
            SQLSelectQueryBlock sqlSelectQueryBlock = (SQLSelectQueryBlock)query;
            Param.parsingSQLSelectItem(sqlSelectQueryBlock);
            SQLTableSource from = sqlSelectQueryBlock.getFrom();
            SqlUtil.parsingTableSource(from);
            SqlUtil.parsingWhere(sqlSelectQueryBlock.getWhere());
            SQLSelectGroupByClause groupBy = sqlSelectQueryBlock.getGroupBy();
            if (groupBy != null) {
                Param.parsingSQLSelectGroupByClause(groupBy);
            }
            if ((order = sqlSelectQueryBlock.getOrderBy()) != null) {
                Param.parsingSQLOrderBy(order);
            }
        } else if (query instanceof SQLUnionQuery) {
            SqlUtil.parserQuery(((SQLUnionQuery)query).getLeft());
            SqlUtil.parserQuery(((SQLUnionQuery)query).getRight());
        }
    }

    private static <T extends SQLExpr> void parsingWhere(T where) {
        if (where == null) {
            return;
        }
        SqlUtil.parserSQLObject(where);
        SQLObject parent = where.getParent();
        if (parent instanceof SQLSelectQueryBlock) {
            SQLExpr newWhere = ((SQLSelectQueryBlock)parent).getWhere();
            SQLExpr newParseWhere = SqlUtil.parsingWhereConstant(newWhere);
            ((SQLSelectQueryBlock)parent).setWhere(newParseWhere);
        } else if (parent instanceof SQLUpdateStatement) {
            SQLExpr newWhere = ((SQLUpdateStatement)parent).getWhere();
            SQLExpr newParseWhere = SqlUtil.parsingWhereConstant(newWhere);
            ((SQLUpdateStatement)parent).setWhere(newParseWhere);
        } else {
            SQLExpr newWhere = ((SQLDeleteStatement)parent).getWhere();
            SQLExpr newParseWhere = SqlUtil.parsingWhereConstant(newWhere);
            ((SQLDeleteStatement)parent).setWhere(newParseWhere);
        }
    }

    public static SQLExpr parsingWhereConstant(SQLExpr sqlExpr) {
        String where = SQLUtils.toSQLString((SQLObject)sqlExpr, (DbType)DB_TYPE_THREAD_LOCAL.get());
        where = where.replaceAll(CONSTANT_CONDITION_REGEX, "").trim();
        int minSize = 3;
        if (where.trim().length() < 3 || CONSTANT_CONDITION.equals(where)) {
            return null;
        }
        sqlExpr = SQLUtils.toSQLExpr((String)where, (DbType)DB_TYPE_THREAD_LOCAL.get());
        if (where.contains(CONSTANT_CONDITION)) {
            return SqlUtil.parsingWhereConstant(sqlExpr);
        }
        return sqlExpr;
    }

    private static void parsingTableSource(SQLTableSource from) {
        if (from instanceof SQLSubqueryTableSource) {
            SQLSelect childSelect = ((SQLSubqueryTableSource)from).getSelect();
            SqlUtil.parserSQLSelect(childSelect);
        } else if (from instanceof SQLJoinTableSource) {
            SQLTableSource left = ((SQLJoinTableSource)from).getLeft();
            SqlUtil.parsingTableSource(left);
            SQLTableSource right = ((SQLJoinTableSource)from).getRight();
            SqlUtil.parsingTableSource(right);
            SQLExpr condition = ((SQLJoinTableSource)from).getCondition();
            if (condition != null) {
                SqlUtil.parserSQLObject(condition);
                SQLExpr newCondition = SqlUtil.parsingWhereConstant(condition);
                ((SQLJoinTableSource)from).setCondition(newCondition);
            }
        } else if (from instanceof SQLUnionQueryTableSource) {
            SqlUtil.parserQuery((SQLSelectQuery)((SQLUnionQueryTableSource)from).getUnion());
        }
    }

    private static void parsingSQLReplaceStatement(SQLReplaceStatement replace) {
        for (SQLInsertStatement.ValuesClause valuesClause : replace.getValuesList()) {
            List values = valuesClause.getValues();
            ArrayList indexs = Lists.newArrayList();
            for (SQLExpr expr : values) {
                if (!Param.unprocessed((SQLObject)expr)) continue;
                indexs.add(values.indexOf(expr));
            }
            for (Integer i : indexs) {
                values.add(i, new SQLIdentifierExpr(null));
            }
        }
    }

    private static List<SQLObject> getMuchPart(SQLObject sqlObject) {
        LinkedList<SQLObject> result = new LinkedList<SQLObject>();
        if (sqlObject == null) {
            return result;
        }
        List children = ((SQLExpr)sqlObject).getChildren();
        if (children != null && !children.isEmpty()) {
            for (SQLObject child : children) {
                if (!(child instanceof SQLExpr)) continue;
                List grandson = ((SQLExpr)child).getChildren();
                if (grandson == null || grandson.isEmpty()) {
                    result.add(sqlObject);
                    break;
                }
                result.addAll(SqlUtil.getMuchPart(child));
            }
        } else {
            return SqlUtil.getMuchPart(sqlObject.getParent());
        }
        return result;
    }

    public static void parserSQLObject(SQLExpr sqlObject) {
        if (sqlObject == null) {
            return;
        }
        List<SQLObject> sqlPartInfo = SqlUtil.getMuchPart((SQLObject)sqlObject);
        for (SQLObject part : sqlPartInfo) {
            SqlUtil.parsingPart(part);
        }
    }

    private static void parsingPart(SQLObject part) {
        if (part instanceof SQLInListExpr) {
            Param.parsingSQLInListExpr((SQLInListExpr)part);
        } else if (part instanceof SQLBinaryOpExpr) {
            Param.parsingSQLBinaryOpExpr((SQLBinaryOpExpr)part);
        } else if (part instanceof SQLMethodInvokeExpr) {
            Param.parsingMethodInvoke((SQLMethodInvokeExpr)part);
        } else if (part instanceof SQLBetweenExpr) {
            Param.parsingSQLBetweenExpr((SQLBetweenExpr)part);
        } else if (part instanceof SQLOrderBy) {
            Param.parsingSQLOrderBy((SQLOrderBy)part);
        } else if (part instanceof SQLSelectGroupByClause) {
            Param.parsingSQLSelectGroupByClause((SQLSelectGroupByClause)part);
        } else if (part instanceof SQLSelectQueryBlock) {
            Param.parsingSQLSelectItem((SQLSelectQueryBlock)part);
        } else if (part instanceof SQLUpdateStatement) {
            SqlUtil.parserUpdate((SQLUpdateStatement)part);
        } else if (part instanceof SQLInsertStatement) {
            SqlUtil.parserInsert((SQLInsertStatement)part);
        } else if (part instanceof SQLDeleteStatement) {
            SqlUtil.parserDelete((SQLDeleteStatement)part);
        } else if (part instanceof SQLSelectStatement) {
            SqlUtil.parserSelect((SQLSelectStatement)part);
        } else if (part instanceof SQLInSubQueryExpr) {
            SqlUtil.parsingInSubQuery((SQLInSubQueryExpr)part);
        } else if (part instanceof SQLPropertyExpr) {
            SqlUtil.parsingPart(part.getParent());
        } else if (part instanceof SQLSelect) {
            SqlUtil.parserSQLSelect((SQLSelect)part);
        } else if (part instanceof SQLSelectQuery) {
            SqlUtil.parserQuery((SQLSelectQuery)part);
        } else if (part instanceof SQLTableSource) {
            SqlUtil.parsingTableSource((SQLTableSource)part);
        } else if (part instanceof SQLReplaceStatement) {
            SqlUtil.parsingSQLReplaceStatement((SQLReplaceStatement)part);
        }
    }

    private static void parsingInSubQuery(SQLInSubQueryExpr c) {
        SQLSelect sqlSelect = c.getSubQuery();
        SQLStatementParser sqlStatementParser = SQLParserUtils.createSQLStatementParser((String)SqlUtil.parserSQL(sqlSelect.toString()), (DbType)DB_TYPE_THREAD_LOCAL.get());
        sqlSelect.setQuery((SQLSelectQuery)((SQLSelectStatement)sqlStatementParser.parseStatement()).getSelect().getQueryBlock());
    }

    public static List<SQLSelectOrderByItem> getSort(String sql) {
        ArrayList<SQLSelectOrderByItem> sorts = new ArrayList<SQLSelectOrderByItem>();
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)DB_TYPE_THREAD_LOCAL.get());
        SQLStatement statement = parser.parseStatement();
        SQLSelectQueryBlock sqlSelectQueryBlock = ((SQLSelectStatement)statement).getSelect().getQueryBlock();
        if (sqlSelectQueryBlock == null) {
            return sorts;
        }
        SQLOrderBy orderBy = sqlSelectQueryBlock.getOrderBy();
        if (orderBy != null) {
            return orderBy.getItems();
        }
        return sorts;
    }

    public static String getTableName(String sql) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)DB_TYPE_THREAD_LOCAL.get());
        SQLStatement statement = parser.parseStatement();
        SchemaStatVisitor visitor = new SchemaStatVisitor(DB_TYPE_THREAD_LOCAL.get());
        statement.accept((SQLASTVisitor)visitor);
        String tableName = null;
        if (statement instanceof SQLUpdateStatement) {
            tableName = SqlUtil.extractUpdateTableName((SQLUpdateStatement)statement);
        } else if (statement instanceof SQLDeleteStatement) {
            tableName = SqlUtil.extractDeleteTableName((SQLDeleteStatement)statement);
        } else if (statement instanceof SQLInsertStatement) {
            tableName = SqlUtil.extractInsertTableName((SQLInsertStatement)statement);
        }
        return tableName;
    }

    private static String extractUpdateTableName(SQLUpdateStatement statement) {
        String tableName = SqlUtil.parseSQLTableSource(statement.getFrom());
        if (tableName == null) {
            tableName = SqlUtil.parseSQLTableSource(statement.getTableSource());
        }
        return tableName;
    }

    private static String extractDeleteTableName(SQLDeleteStatement statement) {
        String tableName = SqlUtil.parseSQLTableSource(statement.getFrom());
        if (tableName == null) {
            tableName = SqlUtil.parseSQLTableSource(statement.getTableSource());
        }
        return tableName;
    }

    private static String extractInsertTableName(SQLInsertStatement statement) {
        String tableName;
        String string = tableName = statement.getTableName() == null ? null : statement.getTableName().getSimpleName();
        if (tableName == null) {
            tableName = SqlUtil.parseSQLTableSource((SQLTableSource)statement.getTableSource());
        }
        return tableName;
    }

    private static String getTableName(SQLUpdateStatement statement) {
        String tableName = SqlUtil.parseSQLTableSource(statement.getFrom());
        if (tableName == null) {
            tableName = SqlUtil.parseSQLTableSource(statement.getTableSource());
        }
        return tableName;
    }

    private static String parseSQLTableSource(SQLTableSource sqlTableSource) {
        if (sqlTableSource instanceof SQLJoinTableSource) {
            return SqlUtil.parseSQLTableSource(((SQLJoinTableSource)sqlTableSource).getLeft());
        }
        if (sqlTableSource instanceof SQLExprTableSource) {
            return ((SQLExprTableSource)sqlTableSource).getName().getSimpleName();
        }
        return null;
    }

    public static void setQueryParamThreadLocal(String key, Object value) {
        ConcurrentMap map = QUERY_PARAM_THREAD_LOCAL.get();
        if (map == null) {
            map = Maps.newConcurrentMap();
            SqlUtil.setQueryParamThreadLocal(map);
        }
        map.put(key, value);
    }

    public static void setQueryParamThreadLocal(Map<String, Object> params) {
        if (params == null) {
            return;
        }
        QUERY_PARAM_THREAD_LOCAL.set(params);
    }

    public static void removeQueryParam(String key) {
        Map<String, Object> map = QUERY_PARAM_THREAD_LOCAL.get();
        if (map != null) {
            map.remove(key);
        }
    }
}

