/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.validate;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.spring.util.spring.MessageUtil;
import cloud.agileframework.validate.ValidateInterface;
import cloud.agileframework.validate.ValidateMsg;
import cloud.agileframework.validate.annotation.Validate;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public enum ValidateType implements ValidateInterface
{
    NO,
    EMAIL("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$", "\u90ae\u7bb1"),
    DOMAIN("(?i)(http://|https://)?(\\w+\\.){1,3}(com(\\.cn)?|com|cn|net|org|gov|edu|int|mil|biz|info|tv|pro|name|museum|coop|aero|CC|SH|ME|asia|kim|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cf|cg|ch|ci|ck|cl|cm|cn|co|cq|cr|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|eh|es|et|ev|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gh|gi|gl|gm|gn|gp|gr|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|in|io|iq|ir|is|it|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|ml|mm|mn|mo|mp|mq|mr|ms|mt|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nt|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|pt|pw|py|qa|re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sy|sz|tc|td|tf|tg|th|tj|tk|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|va|vc|ve|vg|vn|vu|wf|ws|ye|yu|za|zm|zr|zw)\\b", "\u57df\u540d"),
    INTERNET_UTL("^http://([\\w-]+\\.)+[\\w-]+(/[\\w-./?%&=]*)?$", "Internet\u5730\u5740"),
    MOBILE_PHONE("^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|1[8|7][0|1|2|3|5|6|7|8|9])\\d{8}$", "\u624b\u673a\u53f7\u7801"),
    PHONE("(^((13[4-9])|(14[7-8])|(15[0-2,7-9])|(165)|(178)|(18[2-4,7-8])|(19[5,8]))\\d{8}|(170[3,5,6])\\d{7}$)|(^((13[0-2])|(14[5,6])|(15[5-6])|(16[6-7])|(17[1,5,6])|(18[5,6]))\\d{8}|(170[4,7-9])\\d{7}$)|(^((133)|(149)|(153)|(162)|(17[3,7])|(18[0,1,9])|(19[1,3,9]))\\d{8}|((170[0-2])|(174[0-5]))\\d{7}$)", "\u7535\u8bdd\u53f7\u7801"),
    CHINA_PHONE("\\d{3}-\\d{8}|\\d{4}-\\d{7}", "\u56fd\u5185\u7535\u8bdd\u53f7\u7801"),
    ID_CARD("^\\d{15}|\\d{18}$", " \u8eab\u4efd\u8bc1\u53f7"),
    SHORT_ID_CARD("^\\d{8,18}|[0-9x]{8,18}|[0-9X]{8,18}?$", "\u77ed\u8eab\u4efd\u8bc1\u53f7\u7801"),
    ACCOUNT("^[a-zA-Z][a-zA-Z0-9_]{4,15}$", "\u5e10\u53f7"),
    PASSWORD("^[a-zA-Z]\\w{5,17}$", "\u5bc6\u7801"),
    STRONG_PASSWORD("^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,10}$", "\u5f3a\u5bc6\u7801"),
    DATE_YYYY_MM_DD("^((((19|20)\\d{2})-(0?[13-9]|1[012])-(0?[1-9]|[12]\\d|30))|(((19|20)\\d{2})-(0?[13578]|1[02])-31)|(((19|20)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|((((19|20)([13579][26]|[2468][048]|0[48]))|(2000))-0?2-29))$", "\u65e5\u671f\uff08yyyy-mm-dd\uff09"),
    MONTH("^(0?[1-9]|1[0-2])$", "\u6708\u4efd"),
    DAY("^((0?[1-9])|((1|2)[0-9])|30|31)$", "\u65e5\u671f\u5929"),
    MONEY("^(0|-?[1-9][0-9]*)$", "\u94b1"),
    XML_FILE_NAME("^([a-zA-Z]+-?)+[a-zA-Z0-9]+\\.[x|X][m|M][l|L]$", "xml\u6587\u4ef6\u540d"),
    CHINESE_LANGUAGE("[\\u4e00-\\u9fa5]", "\u4e2d\u6587"),
    TWO_CHAR("[^\\x00-\\xff]", "\u53cc\u5b57\u8282\u5b57\u7b26"),
    QQ("[1-9][0-9]{4,}", "QQ\u53f7"),
    MAIL_NO("[1-9]\\d{5}(?!\\d)", "\u4e2d\u56fd\u90ae\u653f\u7f16\u7801"),
    IP("((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))", "IP\u5730\u5740"),
    NUMBER("^[-+]?[0-9]*[.]?[0-9]*[fFL]?$", "\u6570\u5b57"),
    FLOAT("^[-+]?[0-9]*[.]?[0-9]*[fFL]$", "\u6d6e\u70b9\u6570"),
    INT("^[-]?[0-9]*$", "\u8bc1\u4e66"),
    DOUBLE("^[-+]?[0-9]*[.]?[0-9]*$", "\u53cc\u7cbe\u5ea6"),
    ENGLISH_NUMBER("^[A-Za-z0-9]+$", "\u82f1\u6587\u6570\u5b57"),
    MAC("(([A-Fa-f0-9]{2}:)|([A-Fa-f0-9]{2}-)){5}[A-Fa-f0-9]{2}", "MAC\u5730\u5740");

    private String regex;
    private String info;

    private ValidateType() {
    }

    private ValidateType(String regex, String info) {
        this.regex = regex;
        this.info = info;
    }

    @Override
    @NotNull
    public List<ValidateMsg> validateParam(String key, Object value, Validate validate) {
        return this.validate(key, value, validate);
    }

    @Override
    @NotNull
    public List<ValidateMsg> validateArray(String key, List<Object> value, Validate validate) {
        ArrayList<ValidateMsg> list = new ArrayList<ValidateMsg>();
        for (int i = 0; i < value.size(); ++i) {
            Object node = value.get(i);
            List<ValidateMsg> vs = this.validate(String.format("%s.%s", key, i), node, validate);
            if (ObjectUtils.isEmpty(vs)) continue;
            list.addAll(vs);
        }
        int size = value.size();
        if (validate.minSize() > size || size > validate.maxSize()) {
            ValidateMsg v = new ValidateMsg(this.createMessage(validate, "\u957f\u5ea6\u8d85\u51fa\u9608\u503c"), false, key, value);
            list.add(v);
        }
        return list;
    }

    private String createMessage(Validate validate, String defaultMessage) {
        String result = StringUtils.isBlank((CharSequence)validate.validateMsg()) && StringUtils.isBlank((CharSequence)validate.validateMsgKey()) && defaultMessage == null ? String.format("\u4e0d\u7b26\u5408%s\u683c\u5f0f", this.info == null ? "\u81ea\u5b9a\u4e49" : this.info) : (!StringUtils.isBlank((CharSequence)validate.validateMsg()) ? validate.validateMsg() : (!StringUtils.isBlank((CharSequence)validate.validateMsgKey()) ? MessageUtil.message((String)validate.validateMsgKey(), (String[])validate.validateMsgParams()) : defaultMessage));
        return result;
    }

    private String createMessage(Validate validate) {
        return this.createMessage(validate, null);
    }

    private List<ValidateMsg> validate(String key, Object value, Validate validate) {
        ArrayList<ValidateMsg> list = new ArrayList<ValidateMsg>();
        Class<?> beanClass = validate.beanClass();
        if (beanClass != Class.class) {
            Object bean = ObjectUtil.to((Object)value, (TypeReference)new TypeReference(beanClass));
            if (bean == null) {
                list.add(new ValidateMsg(value == null ? "\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a" : "\u975e\u6cd5\u53c2\u6570", false, key, value));
            } else {
                ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                Validator validator = validatorFactory.getValidator();
                Set set = validator.validate(bean, validate.validateGroups());
                for (ConstraintViolation m : set) {
                    ValidateMsg r = new ValidateMsg(m.getMessage(), false, StringUtils.isBlank((CharSequence)key) ? m.getPropertyPath().toString() : String.format("%s.%s", key, m.getPropertyPath()), m.getInvalidValue());
                    list.add(r);
                }
            }
            return list;
        }
        ValidateMsg v = new ValidateMsg(key, value);
        list.add(v);
        if (value != null) {
            boolean state;
            if (!validate.isBlank()) {
                boolean bl = state = !StringUtils.isBlank((CharSequence)value.toString());
                if (!state) {
                    v.setState(false);
                    v.setMessage(this.createMessage(validate, "\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u503c"));
                }
            }
            if (!StringUtils.isBlank((CharSequence)value.toString())) {
                if (validate.validateType() != NO && !(state = PatternUtil.matches((String)this.regex, (String)String.valueOf(value)))) {
                    v.setState(false);
                    v.setMessage(this.createMessage(validate));
                }
                if (!StringUtils.isEmpty((CharSequence)validate.validateRegex()) && !(state = PatternUtil.matches((String)validate.validateRegex(), (String)String.valueOf(value)))) {
                    v.setState(false);
                    v.setMessage(this.createMessage(validate));
                }
                if (validate.validateType() == NUMBER || validate.validateType() == FLOAT || validate.validateType() == INT || validate.validateType() == DOUBLE) {
                    Number n;
                    Number number = n = "".equals(value) ? (Number)0 : (Number)NumberUtils.createNumber((String)String.valueOf(value));
                    if (!(validate.min() <= n.doubleValue()) || !(n.doubleValue() <= validate.max())) {
                        v.setState(false);
                        v.setMessage(this.createMessage(validate, "\u503c\u8d85\u51fa\u9608\u503c"));
                    }
                }
            }
            int size = String.valueOf(value).length();
            if (validate.minSize() > size || size > validate.maxSize()) {
                v.setState(false);
                v.setMessage(this.createMessage(validate, "\u957f\u5ea6\u8d85\u51fa\u9608\u503c"));
            }
        } else if (!validate.nullable()) {
            v.setState(false);
            v.setMessage(this.createMessage(validate, "\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u503c"));
        }
        return list;
    }
}

