/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.config;

import cloud.agileframework.spring.properties.ApplicationProperties;
import cloud.agileframework.spring.util.ResourceUtil;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={ApplicationProperties.class})
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
@Configuration
public class MessageResourceAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.messages")
    @ConditionalOnMissingBean(value={MessageSourceProperties.class})
    public MessageSourceProperties messageSourceProperties() {
        return new MessageSourceProperties();
    }

    @Bean
    public MessageSource messageSource(MessageSourceProperties properties) throws IOException {
        String[] basenameSource = StringUtils.commaDelimitedListToStringArray((String)(StringUtils.trimAllWhitespace((String)properties.getBasename()) + ",/message"));
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        Set classpath = Collections.list(MessageResourceAutoConfiguration.class.getClassLoader().getResources("")).stream().map(URL::getPath).collect(Collectors.toSet());
        String[] baseNames = Arrays.stream(basenameSource).map(basename -> ResourceUtil.getResources(basename, "properties")).filter(Objects::nonNull).flatMap(Arrays::stream).map(resource -> {
            try {
                URL url = resource.getURL();
                String path = URLDecoder.decode(url.getPath(), Charset.defaultCharset().name());
                String jar = ".jar!/";
                if (ResourceUtils.isJarURL((URL)url) && path.contains(".jar!/")) {
                    return path.substring(path.indexOf(".jar!/") + 6, path.indexOf(".properties"));
                }
                return this.extractMessagesBaseNames(classpath, path);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet()).toArray(new String[0]);
        messageSource.setBasenames(baseNames);
        if (properties.getEncoding() != null) {
            messageSource.setDefaultEncoding(properties.getEncoding().name());
        }
        messageSource.setFallbackToSystemLocale(properties.isFallbackToSystemLocale());
        Duration cacheDuration = properties.getCacheDuration();
        if (cacheDuration != null) {
            messageSource.setCacheMillis(cacheDuration.toMillis());
        }
        messageSource.setAlwaysUseMessageFormat(properties.isAlwaysUseMessageFormat());
        messageSource.setUseCodeAsDefaultMessage(properties.isUseCodeAsDefaultMessage());
        return messageSource;
    }

    private String extractMessagesBaseNames(Set<String> classpath, String filePath) {
        for (String currentClasspath : classpath) {
            if (!filePath.contains(currentClasspath)) continue;
            return filePath.substring(filePath.indexOf(currentClasspath) + currentClasspath.length(), filePath.indexOf(".properties"));
        }
        return null;
    }
}

