/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.sync;

import cloud.agileframework.spring.sync.Runner;
import cloud.agileframework.spring.sync.RunnerWrapper;
import cloud.agileframework.spring.sync.ThreadFactory;
import cloud.agileframework.spring.util.BeanUtil;
import java.time.Duration;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncManager {
    private static final int OPERATE_DELAY_TIME = 10;
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory("\u5ef6\u65f6\u961f\u5217"));
    private final ThreadPoolExecutor executor2 = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Integer.MAX_VALUE, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory("\u963b\u585e\u961f\u5217"));
    private static volatile AsyncManager single;
    private static final RunnerWrapper RUNNER_WRAPPER;

    private AsyncManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsyncManager getSingle() {
        if (single != null) {
            return single;
        }
        Class<AsyncManager> clazz = AsyncManager.class;
        synchronized (AsyncManager.class) {
            if (single != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return single;
            }
            single = new AsyncManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public static void execute(Runner task) {
        AsyncManager.getSingle().executor2.execute(() -> RUNNER_WRAPPER.run(task));
    }

    public static void execute(final Runner task, Duration duration) {
        AsyncManager.getSingle().executor.schedule(new TimerTask(){

            @Override
            public void run() {
                RUNNER_WRAPPER.run(task);
            }
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        if (!AsyncManager.getSingle().executor.isShutdown()) {
            AsyncManager.getSingle().executor.shutdown();
            try {
                if (!AsyncManager.getSingle().executor.awaitTermination(2L, TimeUnit.MINUTES)) {
                    AsyncManager.getSingle().executor.shutdownNow();
                }
            }
            catch (InterruptedException var2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        RUNNER_WRAPPER = BeanUtil.getBean(RunnerWrapper.class);
    }
}

