/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.support.AopUtils;

public class AopUtil
extends AopUtils {
    public static <T> T getTarget(JoinPoint joinPoint, Class<T> clazz) {
        Object target = joinPoint.getTarget();
        if (target != null && clazz.isAssignableFrom(target.getClass())) {
            return (T)target;
        }
        return null;
    }

    public static Method getMethod(JoinPoint joinPoint) {
        try {
            String methodName = joinPoint.getSignature().getName();
            Class<?> targetClass = joinPoint.getTarget().getClass();
            Class[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getParameterTypes();
            return targetClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

