/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

public class BeanUtil {
    private static ApplicationContext applicationContext;

    private BeanUtil() {
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        BeanUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            applicationContext = ContextLoader.getCurrentWebApplicationContext();
        }
        return applicationContext;
    }

    public static <T> T getBean(Class<T> clazz) {
        try {
            return (T)applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getBean(String clazz) {
        try {
            return applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getBeanClass(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            return AopProxyUtils.ultimateTargetClass((Object)bean);
        }
        return bean.getClass();
    }
}

