/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.file.poi.CellInfo;
import cloud.agileframework.common.util.file.poi.POIUtil;
import cloud.agileframework.spring.util.MultipartFileUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class POIUtilOfMultipartFile
extends POIUtil {
    private static final Logger log = LoggerFactory.getLogger(POIUtilOfMultipartFile.class);

    public static List<Map<String, Object>> readExcel(MultipartFile file) {
        return POIUtilOfMultipartFile.readExcel(file, null);
    }

    public static List<Map<String, Object>> readExcel(MultipartFile file, List<CellInfo> columns) {
        Workbook excel = POIUtilOfMultipartFile.parsing(file);
        return POIUtilOfMultipartFile.readExcel((TypeReference)new TypeReference<Map<String, Object>>(){}, columns, (Workbook)excel);
    }

    public static <T> List<T> readExcel(MultipartFile file, Class<T> clazz, List<CellInfo> columns) {
        Workbook excel = POIUtilOfMultipartFile.parsing(file);
        return POIUtilOfMultipartFile.readExcel((TypeReference)new TypeReference(clazz), columns, (Workbook)excel);
    }

    private static Workbook parsing(MultipartFile file) {
        Object result = null;
        String xls = "xls";
        if (file != null) {
            String[] s = Objects.requireNonNull(file.getOriginalFilename()).split("[.]");
            String suffix = s.length > 1 ? s[s.length - 1] : Objects.requireNonNull(MultipartFileUtil.getFormat(file)).toLowerCase();
            try {
                result = "xls".equals(suffix) ? new HSSFWorkbook(file.getInputStream()) : new XSSFWorkbook(file.getInputStream());
            }
            catch (Exception e) {
                log.error("excel\u6587\u4ef6\u89e3\u6790\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        return result;
    }
}

