/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class ResourceUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    private static Class forName(String entryPath) {
        Class<?> result;
        String name = entryPath.replace("/", ".").replace(".class", "");
        try {
            result = Class.forName(name);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    private static JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith(FILE_URL_PREFIX)) {
            try {
                return new JarFile(ResourceUtil.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring(FILE_URL_PREFIX.length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findJarFilePaths(URL rootDirURL, String extension, Set<String> fileResourcePaths) throws IOException {
        JarFile jarFile;
        URLConnection con = rootDirURL.openConnection();
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarFile = jarCon.getJarFile();
        } else {
            String urlFile = rootDirURL.getFile();
            int separatorIndex = urlFile.indexOf(WAR_URL_SEPARATOR);
            if (separatorIndex == -1) {
                separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
            }
            if (separatorIndex != -1) {
                String jarFileUrl = urlFile.substring(0, separatorIndex);
                jarFile = ResourceUtil.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
            }
        }
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.endsWith(extension)) continue;
                fileResourcePaths.add(entryPath);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)jarFile, null);
        }
    }

    private static void findClassInPackageByFile(String filePath, String extension, Set<String> classes) {
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(file -> {
            boolean acceptDir = file.isDirectory();
            boolean acceptClass = file.getName().endsWith(extension);
            return acceptDir || acceptClass;
        });
        if (dirFiles == null || dirFiles.length == 0) {
            return;
        }
        for (File file2 : dirFiles) {
            if (file2.isDirectory()) {
                ResourceUtil.findClassInPackageByFile(file2.getAbsolutePath(), extension, classes);
                continue;
            }
            String reourcePath = file2.getAbsolutePath().replace("\\", "/").replace(Thread.currentThread().getContextClassLoader().getResource("").getPath().replaceFirst("/", ""), "");
            try {
                classes.add(reourcePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
    }

    public static Set<Class<?>> getClassFromPackage(String packageName, boolean recursive) {
        HashSet classes = new HashSet();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                HashSet<String> paths = new HashSet<String>();
                if (URL_PROTOCOL_FILE.equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ResourceUtil.findClassInPackageByFile(filePath, ".class", paths);
                } else if (URL_PROTOCOL_JAR.equals(protocol)) {
                    ResourceUtil.findJarFilePaths(url, ".class", paths);
                }
                for (String path : paths) {
                    Class clazz = ResourceUtil.forName(path);
                    if (clazz == null) continue;
                    classes.add(clazz);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static Resource[] getResources(String name, String extension) {
        ClassLoader classLoader = ResourceUtil.class.getClassLoader();
        String target = name.replace('.', '/');
        try {
            return new PathMatchingResourcePatternResolver(classLoader).getResources("classpath*:" + target + "." + extension);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getClassPath(Resource resource) throws IOException {
        String classesPath = ResourceUtil.class.getResource("/").getPath();
        classesPath = URLDecoder.decode(classesPath, "utf-8");
        String path = URLDecoder.decode(resource.getURL().getPath(), "utf-8");
        if (path.contains(classesPath)) {
            return path.replaceFirst(classesPath, "");
        }
        if ((path = path.replaceFirst("classes", "test-classes")).contains(classesPath)) {
            return path.replaceFirst(classesPath, "");
        }
        return null;
    }
}

