/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final ServletOutputStream out = new WrapperOutputStream(this.buffer);
    private final PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, this.getCharacterEncoding()));

    public ResponseWrapper(HttpServletResponse resp) throws IOException {
        super(resp);
    }

    public static HttpServletResponse of(HttpServletResponse response) throws IOException {
        if (!(response instanceof ResponseWrapper)) {
            response = new ResponseWrapper((HttpServletResponse)response);
        }
        return response;
    }

    public ServletOutputStream getOutputStream() {
        return this.out;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void reset() {
        this.buffer.reset();
    }

    public byte[] getResponseData() throws IOException {
        this.flushBuffer();
        return this.buffer.toByteArray();
    }

    private static class WrapperOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream bos;

        public WrapperOutputStream(ByteArrayOutputStream stream) {
            this.bos = stream;
        }

        public void write(int b) {
            this.bos.write(b);
        }

        public void write(byte[] b) {
            this.bos.write(b, 0, b.length);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

