/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.spring.util.ServletUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUtil {
    private static final String AGILE_SECURITY = "$AGILE_SECURITY";
    private static final String AGILE_SECURITY_USER_NAME = "$AGILE_SECURITY_USER_NAME";
    private static final String ANONYMOUS_USERNAME = "anonymous";

    public static UserDetails currentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            authentication = (Authentication)ServletUtil.getCurrentRequest().getAttribute(AGILE_SECURITY);
        }
        if (authentication != null && authentication.getPrincipal() instanceof UserDetails) {
            return (UserDetails)authentication.getPrincipal();
        }
        return new User(ANONYMOUS_USERNAME, "", (Collection)Lists.newArrayList());
    }

    public static String currentUsername() {
        Object username = ServletUtil.getCurrentRequest().getAttribute(AGILE_SECURITY_USER_NAME);
        return username == null ? ANONYMOUS_USERNAME : (String)username;
    }

    public static void setCurrentUser(HttpServletRequest request, Authentication currentAuthentication) {
        request.setAttribute(AGILE_SECURITY, (Object)currentAuthentication);
        request.setAttribute(AGILE_SECURITY_USER_NAME, (Object)((UserDetails)currentAuthentication.getPrincipal()).getUsername());
    }
}

