/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.http.HttpUtil;
import cloud.agileframework.common.util.stream.StreamUtil;
import cloud.agileframework.spring.util.PropertiesUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    public static String getCurrentRequestIP() {
        HttpServletRequest request = ServletUtil.getCurrentRequest();
        return ServletUtil.getRequestIP(request);
    }

    public static String getCurrentRequestUrl() {
        HttpServletRequest request = ServletUtil.getCurrentRequest();
        return request.getRequestURI();
    }

    public static String getRequestIP(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String ip = request.getHeader(PropertiesUtil.getProperty((String)"agile.security.real-ip-header", (String)"X-Real-Ip"));
        String unknown = "unknown";
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ServletUtil.localhostFormat(ip);
    }

    public static String localhostFormat(String ip) {
        String localhost = "127.0.0.1";
        String localhost2 = "0:0:0:0:0:0:0:1";
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownhostexception) {
                ip = "\u672a\u77e5IP\u5730\u5740";
            }
        }
        return ip;
    }

    private static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        String windows = "windows";
        if (osName.toLowerCase().contains("windows")) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public static String getLocalIP() {
        if (ServletUtil.isWindowsOS()) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                return "\u672a\u77e5";
            }
        }
        return ServletUtil.getLinuxLocalIp();
    }

    public static byte[] getBody(HttpServletRequest request) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            StreamUtil.toOutputStream((InputStream)request.getInputStream(), (OutputStream)bytes);
            return bytes.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrentUrl(HttpServletRequest request) {
        if (request != null) {
            return request.getRequestURL().toString();
        }
        return null;
    }

    public static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        throw new RuntimeException("not found request");
    }

    public static HttpServletResponse getCurrentResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        throw new RuntimeException("not found response");
    }

    public static String getCurrentSessionId() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return requestAttributes.getSessionId();
        }
        return null;
    }

    public static List<RequestMatcher> coverRequestMatcher(String ... urls) {
        ArrayList<RequestMatcher> list = new ArrayList<RequestMatcher>();
        for (String url : urls) {
            list.add((RequestMatcher)new AntPathRequestMatcher(url));
        }
        return list;
    }

    public static boolean matcherRequest(HttpServletRequest request, String ... paths) {
        for (String path : paths) {
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(path);
            if (!matcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    public static boolean matcherRequest(HttpServletRequest request, Collection<RequestMatcher> requestMatchers) {
        for (RequestMatcher requestMatcher : requestMatchers) {
            if (!requestMatcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    public static List<InetAddress> getLocalIpAddress() {
        return HttpUtil.getLocalIpAddress();
    }
}

