/*
 * Decompiled with CFR 0.152.
 */
package cloud.pace.sdk.api;

import cloud.pace.sdk.utils.Environment;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0005J,\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004R6\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u0019"}, d2={"Lcloud/pace/sdk/api/API;", "", "()V", "<set-?>", "", "", "additionalHeaders", "getAdditionalHeaders", "()Ljava/util/Map;", "apiKey", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "baseUrl", "getBaseUrl", "setBaseUrl", "addAuthorizationHeader", "", "accessToken", "addHeader", "key", "value", "removeHeader", "setup", "cloud.pace.sdk"})
public final class API {
    @NotNull
    public static final API INSTANCE = new API();
    @NotNull
    private static String baseUrl = Environment.PRODUCTION.getApiUrl();
    @NotNull
    private static String apiKey = "";
    @NotNull
    private static Map<String, String> additionalHeaders = MapsKt.emptyMap();

    private API() {
    }

    @NotNull
    public final String getBaseUrl() {
        return baseUrl;
    }

    public final void setBaseUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        baseUrl = string;
    }

    @NotNull
    public final String getApiKey() {
        return apiKey;
    }

    public final void setApiKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        apiKey = string;
    }

    @NotNull
    public final Map<String, String> getAdditionalHeaders() {
        return additionalHeaders;
    }

    public final void setup(@NotNull String baseUrl, @NotNull String apiKey, @NotNull Map<String, String> additionalHeaders) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter(additionalHeaders, (String)"additionalHeaders");
        API.baseUrl = baseUrl;
        API.apiKey = apiKey;
        API.additionalHeaders = additionalHeaders;
    }

    public static /* synthetic */ void setup$default(API aPI, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        aPI.setup(string, string2, map);
    }

    public final void addHeader(@NotNull String key, @NotNull String value) {
        Map currentHeaders;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map = currentHeaders = MapsKt.toMutableMap(additionalHeaders);
        boolean bl = false;
        map.put(key, value);
        additionalHeaders = currentHeaders;
    }

    public final void removeHeader(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map currentHeaders = MapsKt.toMutableMap(additionalHeaders);
        currentHeaders.remove(key);
        additionalHeaders = currentHeaders;
    }

    public final void addAuthorizationHeader(@Nullable String accessToken) {
        if (accessToken == null) {
            this.removeHeader("Authorization");
        } else {
            this.addHeader("Authorization", "Bearer " + accessToken);
        }
    }
}

